/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import ch.qos.logback.core.CoreConstants;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class JsonFormatter {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final ObjectMapper objectMapper;
    private final boolean doesAppendLineSeparator;
    private final int bufferSize;

    public JsonFormatter(ObjectMapper objectMapper, boolean prettyPrint, boolean doesAppendLineSeparator, int bufferSize) {
        this.objectMapper = prettyPrint ? objectMapper.enable(SerializationFeature.INDENT_OUTPUT) : objectMapper;
        this.doesAppendLineSeparator = doesAppendLineSeparator;
        this.bufferSize = bufferSize;
    }

    public JsonFormatter(ObjectMapper objectMapper, boolean prettyPrint, boolean doesAppendLineSeparator) {
        this(objectMapper, prettyPrint, doesAppendLineSeparator, 512);
    }

    public @Nullable String toJson(@Nullable Map<String, Object> map) {
        String string;
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringWriter writer = new StringWriter(this.bufferSize);
        try {
            this.objectMapper.writeValue((Writer)writer, map);
            if (this.doesAppendLineSeparator) {
                writer.append(CoreConstants.LINE_SEPARATOR);
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to format map as a JSON", e);
            }
        }
        writer.close();
        return string;
    }
}

