/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class TimestampFormatter {
    private static final Map<String, DateTimeFormatter> FORMATTERS = Map.ofEntries(Map.entry("ISO_LOCAL_DATE", DateTimeFormatter.ISO_LOCAL_DATE), Map.entry("ISO_OFFSET_DATE", DateTimeFormatter.ISO_OFFSET_DATE), Map.entry("ISO_DATE", DateTimeFormatter.ISO_DATE), Map.entry("ISO_LOCAL_TIME", DateTimeFormatter.ISO_LOCAL_TIME), Map.entry("ISO_OFFSET_TIME", DateTimeFormatter.ISO_OFFSET_TIME), Map.entry("ISO_TIME", DateTimeFormatter.ISO_TIME), Map.entry("ISO_LOCAL_DATE_TIME", DateTimeFormatter.ISO_LOCAL_DATE_TIME), Map.entry("ISO_OFFSET_DATE_TIME", DateTimeFormatter.ISO_OFFSET_DATE_TIME), Map.entry("ISO_ZONED_DATE_TIME", DateTimeFormatter.ISO_ZONED_DATE_TIME), Map.entry("ISO_DATE_TIME", DateTimeFormatter.ISO_DATE_TIME), Map.entry("ISO_ORDINAL_DATE", DateTimeFormatter.ISO_ORDINAL_DATE), Map.entry("ISO_WEEK_DATE", DateTimeFormatter.ISO_WEEK_DATE), Map.entry("ISO_INSTANT", DateTimeFormatter.ISO_INSTANT), Map.entry("BASIC_ISO_DATE", DateTimeFormatter.BASIC_ISO_DATE), Map.entry("RFC_1123_DATE_TIME", DateTimeFormatter.RFC_1123_DATE_TIME));
    private final @Nullable DateTimeFormatter dateTimeFormatter;

    public TimestampFormatter(@Nullable String timestampFormat, ZoneId zoneId) {
        this.dateTimeFormatter = timestampFormat != null ? Optional.ofNullable(FORMATTERS.get(timestampFormat)).orElseGet(() -> DateTimeFormatter.ofPattern(timestampFormat)).withZone(zoneId) : null;
    }

    public Object format(long timestamp) {
        return this.dateTimeFormatter == null ? Long.valueOf(timestamp) : this.dateTimeFormatter.format(Instant.ofEpochMilli(timestamp));
    }
}

