/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.common;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.validation.Validators;
import io.dropwizard.logging.common.BootstrapLogging;
import io.dropwizard.testing.common.DropwizardTestResourceConfig;
import io.dropwizard.testing.common.ResourceTestJerseyConfiguration;
import io.dropwizard.testing.junit5.ResourceExtension;
import jakarta.validation.Validator;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.jspecify.annotations.Nullable;

public class Resource {
    private ResourceTestJerseyConfiguration configuration;
    private @Nullable JerseyTest test;

    public static ResourceExtension.Builder builder() {
        return new ResourceExtension.Builder();
    }

    private Resource(ResourceTestJerseyConfiguration configuration) {
        this.configuration = configuration;
    }

    public Validator getValidator() {
        return this.configuration.validator;
    }

    public ObjectMapper getObjectMapper() {
        return this.configuration.mapper;
    }

    public Consumer<ClientConfig> getClientConfigurator() {
        return this.configuration.clientConfigurator;
    }

    public WebTarget target(String path) {
        return this.getJerseyTest().target(path);
    }

    public Client client() {
        return this.getJerseyTest().client();
    }

    public JerseyTest getJerseyTest() {
        return Objects.requireNonNull(this.test);
    }

    public void before() throws Throwable {
        DropwizardTestResourceConfig.CONFIGURATION_REGISTRY.put(this.configuration.getId(), this.configuration);
        this.test = new JerseyTest(this.configuration.testContainerFactory){

            protected URI getBaseUri() {
                this.forceSet("jersey.config.test.container.port", "0");
                return super.getBaseUri();
            }

            protected DeploymentContext configureDeployment() {
                return ServletDeploymentContext.builder((Application)new DropwizardTestResourceConfig(Resource.this.configuration)).initParam("jakarta.ws.rs.Application", DropwizardTestResourceConfig.class.getName()).initParam("io.dropwizard.testing.junit.resourceTestJerseyConfigurationId", Resource.this.configuration.getId()).build();
            }

            protected void configureClient(ClientConfig clientConfig) {
                JacksonXmlBindJsonProvider jsonProvider = new JacksonXmlBindJsonProvider();
                jsonProvider.setMapper(Resource.this.configuration.mapper);
                Resource.this.configuration.clientConfigurator.accept(clientConfig);
                clientConfig.register((Object)jsonProvider);
            }
        };
        this.test.setUp();
    }

    public void after() throws Throwable {
        DropwizardTestResourceConfig.CONFIGURATION_REGISTRY.remove(this.configuration.getId());
        Objects.requireNonNull(this.test).tearDown();
    }

    public static class Builder<B extends Builder<B>> {
        private final Set<Supplier<?>> singletons = new HashSet();
        private final Set<Class<?>> providers = new HashSet();
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private MetricRegistry metricRegistry = new MetricRegistry();
        private ObjectMapper mapper = Jackson.newObjectMapper();
        private Validator validator = Validators.newValidator();
        private Consumer<ClientConfig> clientConfigurator = c -> {};
        private TestContainerFactory testContainerFactory = new InMemoryTestContainerFactory();
        private boolean registerDefaultExceptionMappers = true;
        private boolean bootstrapLogging = true;

        public B setMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return (B)this;
        }

        public B setMetricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return (B)this;
        }

        public B setValidator(Validator validator) {
            this.validator = validator;
            return (B)this;
        }

        public B setClientConfigurator(Consumer<ClientConfig> clientConfigurator) {
            this.clientConfigurator = clientConfigurator;
            return (B)this;
        }

        public B addResource(Object resource) {
            return this.addResource(() -> resource);
        }

        public B addResource(Supplier<Object> resourceSupplier) {
            this.singletons.add(resourceSupplier);
            return (B)this;
        }

        public B addProvider(Class<?> klass) {
            this.providers.add(klass);
            return (B)this;
        }

        public B addProvider(Supplier<Object> providerSupplier) {
            this.singletons.add(providerSupplier);
            return (B)this;
        }

        public B addProvider(Object provider) {
            return this.addProvider(() -> provider);
        }

        public B addProperty(String property, Object value) {
            this.properties.put(property, value);
            return (B)this;
        }

        public B setTestContainerFactory(TestContainerFactory factory) {
            this.testContainerFactory = factory;
            return (B)this;
        }

        public B setRegisterDefaultExceptionMappers(boolean value) {
            this.registerDefaultExceptionMappers = value;
            return (B)this;
        }

        public B bootstrapLogging(boolean value) {
            this.bootstrapLogging = value;
            return (B)this;
        }

        protected Resource buildResource() {
            if (this.bootstrapLogging) {
                BootstrapLogging.bootstrap();
            }
            Consumer<ClientConfig> extendedConfigurator = config -> {
                this.clientConfigurator.accept((ClientConfig)config);
                config.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
            };
            return new Resource(new ResourceTestJerseyConfiguration(this.singletons, this.providers, this.properties, this.mapper, this.metricRegistry, this.validator, extendedConfigurator, this.testContainerFactory, this.registerDefaultExceptionMappers));
        }
    }
}

