/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.Charset;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public abstract class View {
    private final String templateName;
    private final @Nullable Charset charset;

    protected View(String templateName) {
        this(templateName, null);
    }

    protected View(String templateName, @Nullable Charset charset) {
        this.templateName = this.resolveName(templateName);
        this.charset = charset;
    }

    @JsonIgnore
    public String getTemplateName() {
        return this.templateName;
    }

    @JsonIgnore
    public Optional<Charset> getCharset() {
        return Optional.ofNullable(this.charset);
    }

    private String resolveName(String templateName) {
        if (templateName.startsWith("/")) {
            return templateName;
        }
        String packagePath = this.getClass().getPackage().getName().replace('.', '/');
        return String.format("/%s/%s", packagePath, templateName);
    }
}

