/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CronJobSpecFluent<A extends CronJobSpecFluent<A>>
extends BaseFluent<A> {
    private String concurrencyPolicy;
    private Integer failedJobsHistoryLimit;
    private JobTemplateSpecBuilder jobTemplate;
    private String schedule;
    private Long startingDeadlineSeconds;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;
    private String timeZone;
    private Map<String, Object> additionalProperties;

    public CronJobSpecFluent() {
    }

    public CronJobSpecFluent(CronJobSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CronJobSpec instance) {
        CronJobSpec cronJobSpec = instance = instance != null ? instance : new CronJobSpec();
        if (instance != null) {
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
            this.withJobTemplate(instance.getJobTemplate());
            this.withSchedule(instance.getSchedule());
            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
            this.withSuspend(instance.getSuspend());
            this.withTimeZone(instance.getTimeZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public A withConcurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return (A)((Object)this);
    }

    public boolean hasConcurrencyPolicy() {
        return this.concurrencyPolicy != null;
    }

    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return (A)((Object)this);
    }

    public boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    public JobTemplateSpec buildJobTemplate() {
        return this.jobTemplate != null ? this.jobTemplate.build() : null;
    }

    public A withJobTemplate(JobTemplateSpec jobTemplate) {
        this._visitables.remove((Object)"jobTemplate");
        if (jobTemplate != null) {
            this.jobTemplate = new JobTemplateSpecBuilder(jobTemplate);
            this._visitables.get((Object)"jobTemplate").add(this.jobTemplate);
        } else {
            this.jobTemplate = null;
            this._visitables.get((Object)"jobTemplate").remove((Object)this.jobTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasJobTemplate() {
        return this.jobTemplate != null;
    }

    public JobTemplateNested<A> withNewJobTemplate() {
        return new JobTemplateNested(null);
    }

    public JobTemplateNested<A> withNewJobTemplateLike(JobTemplateSpec item) {
        return new JobTemplateNested(item);
    }

    public JobTemplateNested<A> editJobTemplate() {
        return this.withNewJobTemplateLike(Optional.ofNullable(this.buildJobTemplate()).orElse(null));
    }

    public JobTemplateNested<A> editOrNewJobTemplate() {
        return this.withNewJobTemplateLike(Optional.ofNullable(this.buildJobTemplate()).orElse(new JobTemplateSpecBuilder().build()));
    }

    public JobTemplateNested<A> editOrNewJobTemplateLike(JobTemplateSpec item) {
        return this.withNewJobTemplateLike(Optional.ofNullable(this.buildJobTemplate()).orElse(item));
    }

    public String getSchedule() {
        return this.schedule;
    }

    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)((Object)this);
    }

    public boolean hasSchedule() {
        return this.schedule != null;
    }

    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds != null;
    }

    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return (A)((Object)this);
    }

    public boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)((Object)this);
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public A withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return (A)((Object)this);
    }

    public boolean hasTimeZone() {
        return this.timeZone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobSpecFluent that = (CronJobSpecFluent)((Object)o);
        if (!Objects.equals(this.concurrencyPolicy, that.concurrencyPolicy)) {
            return false;
        }
        if (!Objects.equals(this.failedJobsHistoryLimit, that.failedJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.jobTemplate, (Object)that.jobTemplate)) {
            return false;
        }
        if (!Objects.equals(this.schedule, that.schedule)) {
            return false;
        }
        if (!Objects.equals(this.startingDeadlineSeconds, that.startingDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.successfulJobsHistoryLimit, that.successfulJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals(this.timeZone, that.timeZone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.concurrencyPolicy, this.failedJobsHistoryLimit, this.jobTemplate, this.schedule, this.startingDeadlineSeconds, this.successfulJobsHistoryLimit, this.suspend, this.timeZone, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.concurrencyPolicy != null) {
            sb.append("concurrencyPolicy:");
            sb.append(this.concurrencyPolicy + ",");
        }
        if (this.failedJobsHistoryLimit != null) {
            sb.append("failedJobsHistoryLimit:");
            sb.append(this.failedJobsHistoryLimit + ",");
        }
        if (this.jobTemplate != null) {
            sb.append("jobTemplate:");
            sb.append((Object)((Object)this.jobTemplate) + ",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule + ",");
        }
        if (this.startingDeadlineSeconds != null) {
            sb.append("startingDeadlineSeconds:");
            sb.append(this.startingDeadlineSeconds + ",");
        }
        if (this.successfulJobsHistoryLimit != null) {
            sb.append("successfulJobsHistoryLimit:");
            sb.append(this.successfulJobsHistoryLimit + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.timeZone != null) {
            sb.append("timeZone:");
            sb.append(this.timeZone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSuspend() {
        return this.withSuspend(true);
    }

    public class JobTemplateNested<N>
    extends JobTemplateSpecFluent<JobTemplateNested<N>>
    implements Nested<N> {
        JobTemplateSpecBuilder builder;

        JobTemplateNested(JobTemplateSpec item) {
            this.builder = new JobTemplateSpecBuilder(this, item);
        }

        public N and() {
            return (N)CronJobSpecFluent.this.withJobTemplate(this.builder.build());
        }

        public N endJobTemplate() {
            return this.and();
        }
    }
}

