/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Taint;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingBuilder;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluent;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolPlatform;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolPlatformBuilder;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolPlatformFluent;
import io.fabric8.openshift.api.model.hive.v1.MachinePoolSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolSpecFluent<A extends MachinePoolSpecFluent<A>>
extends BaseFluent<A> {
    private MachinePoolAutoscalingBuilder autoscaling;
    private LocalObjectReferenceBuilder clusterDeploymentRef;
    private Map<String, String> labels;
    private Map<String, String> machineLabels;
    private String name;
    private MachinePoolPlatformBuilder platform;
    private Long replicas;
    private List<Taint> taints = new ArrayList<Taint>();
    private Map<String, Object> additionalProperties;

    public MachinePoolSpecFluent() {
    }

    public MachinePoolSpecFluent(MachinePoolSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePoolSpec instance) {
        MachinePoolSpec machinePoolSpec = instance = instance != null ? instance : new MachinePoolSpec();
        if (instance != null) {
            this.withAutoscaling(instance.getAutoscaling());
            this.withClusterDeploymentRef(instance.getClusterDeploymentRef());
            this.withLabels(instance.getLabels());
            this.withMachineLabels(instance.getMachineLabels());
            this.withName(instance.getName());
            this.withPlatform(instance.getPlatform());
            this.withReplicas(instance.getReplicas());
            this.withTaints(instance.getTaints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachinePoolAutoscaling buildAutoscaling() {
        return this.autoscaling != null ? this.autoscaling.build() : null;
    }

    public A withAutoscaling(MachinePoolAutoscaling autoscaling) {
        this._visitables.remove((Object)"autoscaling");
        if (autoscaling != null) {
            this.autoscaling = new MachinePoolAutoscalingBuilder(autoscaling);
            this._visitables.get((Object)"autoscaling").add(this.autoscaling);
        } else {
            this.autoscaling = null;
            this._visitables.get((Object)"autoscaling").remove((Object)this.autoscaling);
        }
        return (A)((Object)this);
    }

    public boolean hasAutoscaling() {
        return this.autoscaling != null;
    }

    public A withNewAutoscaling(Integer maxReplicas, Integer minReplicas) {
        return this.withAutoscaling(new MachinePoolAutoscaling(maxReplicas, minReplicas));
    }

    public AutoscalingNested<A> withNewAutoscaling() {
        return new AutoscalingNested(null);
    }

    public AutoscalingNested<A> withNewAutoscalingLike(MachinePoolAutoscaling item) {
        return new AutoscalingNested(item);
    }

    public AutoscalingNested<A> editAutoscaling() {
        return this.withNewAutoscalingLike(Optional.ofNullable(this.buildAutoscaling()).orElse(null));
    }

    public AutoscalingNested<A> editOrNewAutoscaling() {
        return this.withNewAutoscalingLike(Optional.ofNullable(this.buildAutoscaling()).orElse(new MachinePoolAutoscalingBuilder().build()));
    }

    public AutoscalingNested<A> editOrNewAutoscalingLike(MachinePoolAutoscaling item) {
        return this.withNewAutoscalingLike(Optional.ofNullable(this.buildAutoscaling()).orElse(item));
    }

    public LocalObjectReference buildClusterDeploymentRef() {
        return this.clusterDeploymentRef != null ? this.clusterDeploymentRef.build() : null;
    }

    public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
        this._visitables.remove((Object)"clusterDeploymentRef");
        if (clusterDeploymentRef != null) {
            this.clusterDeploymentRef = new LocalObjectReferenceBuilder(clusterDeploymentRef);
            this._visitables.get((Object)"clusterDeploymentRef").add(this.clusterDeploymentRef);
        } else {
            this.clusterDeploymentRef = null;
            this._visitables.get((Object)"clusterDeploymentRef").remove(this.clusterDeploymentRef);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterDeploymentRef() {
        return this.clusterDeploymentRef != null;
    }

    public A withNewClusterDeploymentRef(String name) {
        return this.withClusterDeploymentRef(new LocalObjectReference(name));
    }

    public ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
        return new ClusterDeploymentRefNested(null);
    }

    public ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
        return new ClusterDeploymentRefNested(item);
    }

    public ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
        return this.withNewClusterDeploymentRefLike(Optional.ofNullable(this.buildClusterDeploymentRef()).orElse(null));
    }

    public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
        return this.withNewClusterDeploymentRefLike(Optional.ofNullable(this.buildClusterDeploymentRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
        return this.withNewClusterDeploymentRefLike(Optional.ofNullable(this.buildClusterDeploymentRef()).orElse(item));
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public A addToMachineLabels(String key, String value) {
        if (this.machineLabels == null && key != null && value != null) {
            this.machineLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.machineLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMachineLabels(Map<String, String> map) {
        if (this.machineLabels == null && map != null) {
            this.machineLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.machineLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMachineLabels(String key) {
        if (this.machineLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.machineLabels != null) {
            this.machineLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMachineLabels(Map<String, String> map) {
        if (this.machineLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.machineLabels == null) continue;
                this.machineLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getMachineLabels() {
        return this.machineLabels;
    }

    public <K, V> A withMachineLabels(Map<String, String> machineLabels) {
        this.machineLabels = machineLabels == null ? null : new LinkedHashMap<String, String>(machineLabels);
        return (A)((Object)this);
    }

    public boolean hasMachineLabels() {
        return this.machineLabels != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public MachinePoolPlatform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    public A withPlatform(MachinePoolPlatform platform) {
        this._visitables.remove((Object)"platform");
        if (platform != null) {
            this.platform = new MachinePoolPlatformBuilder(platform);
            this._visitables.get((Object)"platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get((Object)"platform").remove((Object)this.platform);
        }
        return (A)((Object)this);
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
        return new PlatformNested(item);
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new MachinePoolPlatformBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public Long getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Long replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        this.taints.add(index, item);
        return (A)((Object)this);
    }

    public A setToTaints(int index, Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        this.taints.set(index, item);
        return (A)((Object)this);
    }

    public A addToTaints(Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        for (Taint item : items) {
            this.taints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTaints(Collection<Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<Taint>();
        }
        for (Taint item : items) {
            this.taints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTaints(Taint ... items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (Taint item : items) {
            this.taints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTaints(Collection<Taint> items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (Taint item : items) {
            this.taints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Taint> getTaints() {
        return this.taints;
    }

    public Taint getTaint(int index) {
        return this.taints.get(index);
    }

    public Taint getFirstTaint() {
        return this.taints.get(0);
    }

    public Taint getLastTaint() {
        return this.taints.get(this.taints.size() - 1);
    }

    public Taint getMatchingTaint(Predicate<Taint> predicate) {
        for (Taint item : this.taints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<Taint> predicate) {
        for (Taint item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<Taint> taints) {
        if (taints != null) {
            this.taints = new ArrayList<Taint>();
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)((Object)this);
    }

    public A withTaints(Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove((Object)"taints");
        }
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolSpecFluent that = (MachinePoolSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.autoscaling, (Object)that.autoscaling)) {
            return false;
        }
        if (!Objects.equals(this.clusterDeploymentRef, that.clusterDeploymentRef)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.machineLabels, that.machineLabels)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.platform, (Object)that.platform)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoscaling, this.clusterDeploymentRef, this.labels, this.machineLabels, this.name, this.platform, this.replicas, this.taints, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoscaling != null) {
            sb.append("autoscaling:");
            sb.append(String.valueOf((Object)this.autoscaling) + ",");
        }
        if (this.clusterDeploymentRef != null) {
            sb.append("clusterDeploymentRef:");
            sb.append(String.valueOf(this.clusterDeploymentRef) + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(String.valueOf(this.labels) + ",");
        }
        if (this.machineLabels != null && !this.machineLabels.isEmpty()) {
            sb.append("machineLabels:");
            sb.append(String.valueOf(this.machineLabels) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(String.valueOf((Object)this.platform) + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(String.valueOf(this.taints) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlatformNested<N>
    extends MachinePoolPlatformFluent<PlatformNested<N>>
    implements Nested<N> {
        MachinePoolPlatformBuilder builder;

        PlatformNested(MachinePoolPlatform item) {
            this.builder = new MachinePoolPlatformBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolSpecFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }

    public class ClusterDeploymentRefNested<N>
    extends LocalObjectReferenceFluent<ClusterDeploymentRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ClusterDeploymentRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)MachinePoolSpecFluent.this.withClusterDeploymentRef(this.builder.build());
        }

        public N endClusterDeploymentRef() {
            return this.and();
        }
    }

    public class AutoscalingNested<N>
    extends MachinePoolAutoscalingFluent<AutoscalingNested<N>>
    implements Nested<N> {
        MachinePoolAutoscalingBuilder builder;

        AutoscalingNested(MachinePoolAutoscaling item) {
            this.builder = new MachinePoolAutoscalingBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolSpecFluent.this.withAutoscaling(this.builder.build());
        }

        public N endAutoscaling() {
            return this.and();
        }
    }
}

