/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSBuildSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSConfigReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSConfigReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSConfigReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineOSBuildSpecFluent<A extends MachineOSBuildSpecFluent<A>>
extends BaseFluent<A> {
    private MachineConfigReferenceBuilder machineConfig;
    private MachineOSConfigReferenceBuilder machineOSConfig;
    private String renderedImagePushSpec;
    private Map<String, Object> additionalProperties;

    public MachineOSBuildSpecFluent() {
    }

    public MachineOSBuildSpecFluent(MachineOSBuildSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineOSBuildSpec instance) {
        MachineOSBuildSpec machineOSBuildSpec = instance = instance != null ? instance : new MachineOSBuildSpec();
        if (instance != null) {
            this.withMachineConfig(instance.getMachineConfig());
            this.withMachineOSConfig(instance.getMachineOSConfig());
            this.withRenderedImagePushSpec(instance.getRenderedImagePushSpec());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachineConfigReference buildMachineConfig() {
        return this.machineConfig != null ? this.machineConfig.build() : null;
    }

    public A withMachineConfig(MachineConfigReference machineConfig) {
        this._visitables.remove((Object)"machineConfig");
        if (machineConfig != null) {
            this.machineConfig = new MachineConfigReferenceBuilder(machineConfig);
            this._visitables.get((Object)"machineConfig").add(this.machineConfig);
        } else {
            this.machineConfig = null;
            this._visitables.get((Object)"machineConfig").remove((Object)this.machineConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasMachineConfig() {
        return this.machineConfig != null;
    }

    public A withNewMachineConfig(String name) {
        return this.withMachineConfig(new MachineConfigReference(name));
    }

    public MachineConfigNested<A> withNewMachineConfig() {
        return new MachineConfigNested(null);
    }

    public MachineConfigNested<A> withNewMachineConfigLike(MachineConfigReference item) {
        return new MachineConfigNested(item);
    }

    public MachineConfigNested<A> editMachineConfig() {
        return this.withNewMachineConfigLike(Optional.ofNullable(this.buildMachineConfig()).orElse(null));
    }

    public MachineConfigNested<A> editOrNewMachineConfig() {
        return this.withNewMachineConfigLike(Optional.ofNullable(this.buildMachineConfig()).orElse(new MachineConfigReferenceBuilder().build()));
    }

    public MachineConfigNested<A> editOrNewMachineConfigLike(MachineConfigReference item) {
        return this.withNewMachineConfigLike(Optional.ofNullable(this.buildMachineConfig()).orElse(item));
    }

    public MachineOSConfigReference buildMachineOSConfig() {
        return this.machineOSConfig != null ? this.machineOSConfig.build() : null;
    }

    public A withMachineOSConfig(MachineOSConfigReference machineOSConfig) {
        this._visitables.remove((Object)"machineOSConfig");
        if (machineOSConfig != null) {
            this.machineOSConfig = new MachineOSConfigReferenceBuilder(machineOSConfig);
            this._visitables.get((Object)"machineOSConfig").add(this.machineOSConfig);
        } else {
            this.machineOSConfig = null;
            this._visitables.get((Object)"machineOSConfig").remove((Object)this.machineOSConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasMachineOSConfig() {
        return this.machineOSConfig != null;
    }

    public A withNewMachineOSConfig(String name) {
        return this.withMachineOSConfig(new MachineOSConfigReference(name));
    }

    public MachineOSConfigNested<A> withNewMachineOSConfig() {
        return new MachineOSConfigNested(null);
    }

    public MachineOSConfigNested<A> withNewMachineOSConfigLike(MachineOSConfigReference item) {
        return new MachineOSConfigNested(item);
    }

    public MachineOSConfigNested<A> editMachineOSConfig() {
        return this.withNewMachineOSConfigLike(Optional.ofNullable(this.buildMachineOSConfig()).orElse(null));
    }

    public MachineOSConfigNested<A> editOrNewMachineOSConfig() {
        return this.withNewMachineOSConfigLike(Optional.ofNullable(this.buildMachineOSConfig()).orElse(new MachineOSConfigReferenceBuilder().build()));
    }

    public MachineOSConfigNested<A> editOrNewMachineOSConfigLike(MachineOSConfigReference item) {
        return this.withNewMachineOSConfigLike(Optional.ofNullable(this.buildMachineOSConfig()).orElse(item));
    }

    public String getRenderedImagePushSpec() {
        return this.renderedImagePushSpec;
    }

    public A withRenderedImagePushSpec(String renderedImagePushSpec) {
        this.renderedImagePushSpec = renderedImagePushSpec;
        return (A)((Object)this);
    }

    public boolean hasRenderedImagePushSpec() {
        return this.renderedImagePushSpec != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineOSBuildSpecFluent that = (MachineOSBuildSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.machineConfig, (Object)that.machineConfig)) {
            return false;
        }
        if (!Objects.equals((Object)this.machineOSConfig, (Object)that.machineOSConfig)) {
            return false;
        }
        if (!Objects.equals(this.renderedImagePushSpec, that.renderedImagePushSpec)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.machineConfig, this.machineOSConfig, this.renderedImagePushSpec, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.machineConfig != null) {
            sb.append("machineConfig:");
            sb.append(String.valueOf((Object)this.machineConfig) + ",");
        }
        if (this.machineOSConfig != null) {
            sb.append("machineOSConfig:");
            sb.append(String.valueOf((Object)this.machineOSConfig) + ",");
        }
        if (this.renderedImagePushSpec != null) {
            sb.append("renderedImagePushSpec:");
            sb.append(this.renderedImagePushSpec + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MachineOSConfigNested<N>
    extends MachineOSConfigReferenceFluent<MachineOSConfigNested<N>>
    implements Nested<N> {
        MachineOSConfigReferenceBuilder builder;

        MachineOSConfigNested(MachineOSConfigReference item) {
            this.builder = new MachineOSConfigReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSBuildSpecFluent.this.withMachineOSConfig(this.builder.build());
        }

        public N endMachineOSConfig() {
            return this.and();
        }
    }

    public class MachineConfigNested<N>
    extends MachineConfigReferenceFluent<MachineConfigNested<N>>
    implements Nested<N> {
        MachineConfigReferenceBuilder builder;

        MachineConfigNested(MachineConfigReference item) {
            this.builder = new MachineConfigReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSBuildSpecFluent.this.withMachineConfig(this.builder.build());
        }

        public N endMachineConfig() {
            return this.and();
        }
    }
}

