/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ImageSecretObjectReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ImageSecretObjectReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ImageSecretObjectReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineConfigPoolReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSConfigSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSContainerfile;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSContainerfileBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSContainerfileFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSImageBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSImageBuilderBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSImageBuilderFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineOSConfigSpecFluent<A extends MachineOSConfigSpecFluent<A>>
extends BaseFluent<A> {
    private ImageSecretObjectReferenceBuilder baseImagePullSecret;
    private ArrayList<MachineOSContainerfileBuilder> containerFile = new ArrayList();
    private MachineOSImageBuilderBuilder imageBuilder;
    private MachineConfigPoolReferenceBuilder machineConfigPool;
    private ImageSecretObjectReferenceBuilder renderedImagePushSecret;
    private String renderedImagePushSpec;
    private Map<String, Object> additionalProperties;

    public MachineOSConfigSpecFluent() {
    }

    public MachineOSConfigSpecFluent(MachineOSConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineOSConfigSpec instance) {
        MachineOSConfigSpec machineOSConfigSpec = instance = instance != null ? instance : new MachineOSConfigSpec();
        if (instance != null) {
            this.withBaseImagePullSecret(instance.getBaseImagePullSecret());
            this.withContainerFile(instance.getContainerFile());
            this.withImageBuilder(instance.getImageBuilder());
            this.withMachineConfigPool(instance.getMachineConfigPool());
            this.withRenderedImagePushSecret(instance.getRenderedImagePushSecret());
            this.withRenderedImagePushSpec(instance.getRenderedImagePushSpec());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ImageSecretObjectReference buildBaseImagePullSecret() {
        return this.baseImagePullSecret != null ? this.baseImagePullSecret.build() : null;
    }

    public A withBaseImagePullSecret(ImageSecretObjectReference baseImagePullSecret) {
        this._visitables.remove((Object)"baseImagePullSecret");
        if (baseImagePullSecret != null) {
            this.baseImagePullSecret = new ImageSecretObjectReferenceBuilder(baseImagePullSecret);
            this._visitables.get((Object)"baseImagePullSecret").add(this.baseImagePullSecret);
        } else {
            this.baseImagePullSecret = null;
            this._visitables.get((Object)"baseImagePullSecret").remove((Object)this.baseImagePullSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasBaseImagePullSecret() {
        return this.baseImagePullSecret != null;
    }

    public A withNewBaseImagePullSecret(String name) {
        return this.withBaseImagePullSecret(new ImageSecretObjectReference(name));
    }

    public BaseImagePullSecretNested<A> withNewBaseImagePullSecret() {
        return new BaseImagePullSecretNested(null);
    }

    public BaseImagePullSecretNested<A> withNewBaseImagePullSecretLike(ImageSecretObjectReference item) {
        return new BaseImagePullSecretNested(item);
    }

    public BaseImagePullSecretNested<A> editBaseImagePullSecret() {
        return this.withNewBaseImagePullSecretLike(Optional.ofNullable(this.buildBaseImagePullSecret()).orElse(null));
    }

    public BaseImagePullSecretNested<A> editOrNewBaseImagePullSecret() {
        return this.withNewBaseImagePullSecretLike(Optional.ofNullable(this.buildBaseImagePullSecret()).orElse(new ImageSecretObjectReferenceBuilder().build()));
    }

    public BaseImagePullSecretNested<A> editOrNewBaseImagePullSecretLike(ImageSecretObjectReference item) {
        return this.withNewBaseImagePullSecretLike(Optional.ofNullable(this.buildBaseImagePullSecret()).orElse(item));
    }

    public A addToContainerFile(int index, MachineOSContainerfile item) {
        if (this.containerFile == null) {
            this.containerFile = new ArrayList();
        }
        MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
        if (index < 0 || index >= this.containerFile.size()) {
            this._visitables.get((Object)"containerFile").add(builder);
            this.containerFile.add(builder);
        } else {
            this._visitables.get((Object)"containerFile").add(builder);
            this.containerFile.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainerFile(int index, MachineOSContainerfile item) {
        if (this.containerFile == null) {
            this.containerFile = new ArrayList();
        }
        MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
        if (index < 0 || index >= this.containerFile.size()) {
            this._visitables.get((Object)"containerFile").add(builder);
            this.containerFile.add(builder);
        } else {
            this._visitables.get((Object)"containerFile").add(builder);
            this.containerFile.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainerFile(MachineOSContainerfile ... items) {
        if (this.containerFile == null) {
            this.containerFile = new ArrayList();
        }
        for (MachineOSContainerfile item : items) {
            MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
            this._visitables.get((Object)"containerFile").add(builder);
            this.containerFile.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainerFile(Collection<MachineOSContainerfile> items) {
        if (this.containerFile == null) {
            this.containerFile = new ArrayList();
        }
        for (MachineOSContainerfile item : items) {
            MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
            this._visitables.get((Object)"containerFile").add(builder);
            this.containerFile.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainerFile(MachineOSContainerfile ... items) {
        if (this.containerFile == null) {
            return (A)((Object)this);
        }
        for (MachineOSContainerfile item : items) {
            MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
            this._visitables.get((Object)"containerFile").remove((Object)builder);
            this.containerFile.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainerFile(Collection<MachineOSContainerfile> items) {
        if (this.containerFile == null) {
            return (A)((Object)this);
        }
        for (MachineOSContainerfile item : items) {
            MachineOSContainerfileBuilder builder = new MachineOSContainerfileBuilder(item);
            this._visitables.get((Object)"containerFile").remove((Object)builder);
            this.containerFile.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
        if (this.containerFile == null) {
            return (A)((Object)this);
        }
        Iterator<MachineOSContainerfileBuilder> each = this.containerFile.iterator();
        List visitables = this._visitables.get((Object)"containerFile");
        while (each.hasNext()) {
            MachineOSContainerfileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MachineOSContainerfile> buildContainerFile() {
        return this.containerFile != null ? MachineOSConfigSpecFluent.build(this.containerFile) : null;
    }

    public MachineOSContainerfile buildContainerFile(int index) {
        return this.containerFile.get(index).build();
    }

    public MachineOSContainerfile buildFirstContainerFile() {
        return this.containerFile.get(0).build();
    }

    public MachineOSContainerfile buildLastContainerFile() {
        return this.containerFile.get(this.containerFile.size() - 1).build();
    }

    public MachineOSContainerfile buildMatchingContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
        for (MachineOSContainerfileBuilder item : this.containerFile) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
        for (MachineOSContainerfileBuilder item : this.containerFile) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerFile(List<MachineOSContainerfile> containerFile) {
        if (this.containerFile != null) {
            this._visitables.get((Object)"containerFile").clear();
        }
        if (containerFile != null) {
            this.containerFile = new ArrayList();
            for (MachineOSContainerfile item : containerFile) {
                this.addToContainerFile(item);
            }
        } else {
            this.containerFile = null;
        }
        return (A)((Object)this);
    }

    public A withContainerFile(MachineOSContainerfile ... containerFile) {
        if (this.containerFile != null) {
            this.containerFile.clear();
            this._visitables.remove((Object)"containerFile");
        }
        if (containerFile != null) {
            for (MachineOSContainerfile item : containerFile) {
                this.addToContainerFile(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainerFile() {
        return this.containerFile != null && !this.containerFile.isEmpty();
    }

    public A addNewContainerFile(String containerfileArch, String content) {
        return this.addToContainerFile(new MachineOSContainerfile(containerfileArch, content));
    }

    public ContainerFileNested<A> addNewContainerFile() {
        return new ContainerFileNested(-1, null);
    }

    public ContainerFileNested<A> addNewContainerFileLike(MachineOSContainerfile item) {
        return new ContainerFileNested(-1, item);
    }

    public ContainerFileNested<A> setNewContainerFileLike(int index, MachineOSContainerfile item) {
        return new ContainerFileNested(index, item);
    }

    public ContainerFileNested<A> editContainerFile(int index) {
        if (this.containerFile.size() <= index) {
            throw new RuntimeException("Can't edit containerFile. Index exceeds size.");
        }
        return this.setNewContainerFileLike(index, this.buildContainerFile(index));
    }

    public ContainerFileNested<A> editFirstContainerFile() {
        if (this.containerFile.size() == 0) {
            throw new RuntimeException("Can't edit first containerFile. The list is empty.");
        }
        return this.setNewContainerFileLike(0, this.buildContainerFile(0));
    }

    public ContainerFileNested<A> editLastContainerFile() {
        int index = this.containerFile.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerFile. The list is empty.");
        }
        return this.setNewContainerFileLike(index, this.buildContainerFile(index));
    }

    public ContainerFileNested<A> editMatchingContainerFile(Predicate<MachineOSContainerfileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerFile.size(); ++i) {
            if (!predicate.test(this.containerFile.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerFile. No match found.");
        }
        return this.setNewContainerFileLike(index, this.buildContainerFile(index));
    }

    public MachineOSImageBuilder buildImageBuilder() {
        return this.imageBuilder != null ? this.imageBuilder.build() : null;
    }

    public A withImageBuilder(MachineOSImageBuilder imageBuilder) {
        this._visitables.remove((Object)"imageBuilder");
        if (imageBuilder != null) {
            this.imageBuilder = new MachineOSImageBuilderBuilder(imageBuilder);
            this._visitables.get((Object)"imageBuilder").add(this.imageBuilder);
        } else {
            this.imageBuilder = null;
            this._visitables.get((Object)"imageBuilder").remove((Object)this.imageBuilder);
        }
        return (A)((Object)this);
    }

    public boolean hasImageBuilder() {
        return this.imageBuilder != null;
    }

    public A withNewImageBuilder(String imageBuilderType) {
        return this.withImageBuilder(new MachineOSImageBuilder(imageBuilderType));
    }

    public ImageBuilderNested<A> withNewImageBuilder() {
        return new ImageBuilderNested(null);
    }

    public ImageBuilderNested<A> withNewImageBuilderLike(MachineOSImageBuilder item) {
        return new ImageBuilderNested(item);
    }

    public ImageBuilderNested<A> editImageBuilder() {
        return this.withNewImageBuilderLike(Optional.ofNullable(this.buildImageBuilder()).orElse(null));
    }

    public ImageBuilderNested<A> editOrNewImageBuilder() {
        return this.withNewImageBuilderLike(Optional.ofNullable(this.buildImageBuilder()).orElse(new MachineOSImageBuilderBuilder().build()));
    }

    public ImageBuilderNested<A> editOrNewImageBuilderLike(MachineOSImageBuilder item) {
        return this.withNewImageBuilderLike(Optional.ofNullable(this.buildImageBuilder()).orElse(item));
    }

    public MachineConfigPoolReference buildMachineConfigPool() {
        return this.machineConfigPool != null ? this.machineConfigPool.build() : null;
    }

    public A withMachineConfigPool(MachineConfigPoolReference machineConfigPool) {
        this._visitables.remove((Object)"machineConfigPool");
        if (machineConfigPool != null) {
            this.machineConfigPool = new MachineConfigPoolReferenceBuilder(machineConfigPool);
            this._visitables.get((Object)"machineConfigPool").add(this.machineConfigPool);
        } else {
            this.machineConfigPool = null;
            this._visitables.get((Object)"machineConfigPool").remove((Object)this.machineConfigPool);
        }
        return (A)((Object)this);
    }

    public boolean hasMachineConfigPool() {
        return this.machineConfigPool != null;
    }

    public A withNewMachineConfigPool(String name) {
        return this.withMachineConfigPool(new MachineConfigPoolReference(name));
    }

    public MachineConfigPoolNested<A> withNewMachineConfigPool() {
        return new MachineConfigPoolNested(null);
    }

    public MachineConfigPoolNested<A> withNewMachineConfigPoolLike(MachineConfigPoolReference item) {
        return new MachineConfigPoolNested(item);
    }

    public MachineConfigPoolNested<A> editMachineConfigPool() {
        return this.withNewMachineConfigPoolLike(Optional.ofNullable(this.buildMachineConfigPool()).orElse(null));
    }

    public MachineConfigPoolNested<A> editOrNewMachineConfigPool() {
        return this.withNewMachineConfigPoolLike(Optional.ofNullable(this.buildMachineConfigPool()).orElse(new MachineConfigPoolReferenceBuilder().build()));
    }

    public MachineConfigPoolNested<A> editOrNewMachineConfigPoolLike(MachineConfigPoolReference item) {
        return this.withNewMachineConfigPoolLike(Optional.ofNullable(this.buildMachineConfigPool()).orElse(item));
    }

    public ImageSecretObjectReference buildRenderedImagePushSecret() {
        return this.renderedImagePushSecret != null ? this.renderedImagePushSecret.build() : null;
    }

    public A withRenderedImagePushSecret(ImageSecretObjectReference renderedImagePushSecret) {
        this._visitables.remove((Object)"renderedImagePushSecret");
        if (renderedImagePushSecret != null) {
            this.renderedImagePushSecret = new ImageSecretObjectReferenceBuilder(renderedImagePushSecret);
            this._visitables.get((Object)"renderedImagePushSecret").add(this.renderedImagePushSecret);
        } else {
            this.renderedImagePushSecret = null;
            this._visitables.get((Object)"renderedImagePushSecret").remove((Object)this.renderedImagePushSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasRenderedImagePushSecret() {
        return this.renderedImagePushSecret != null;
    }

    public A withNewRenderedImagePushSecret(String name) {
        return this.withRenderedImagePushSecret(new ImageSecretObjectReference(name));
    }

    public RenderedImagePushSecretNested<A> withNewRenderedImagePushSecret() {
        return new RenderedImagePushSecretNested(null);
    }

    public RenderedImagePushSecretNested<A> withNewRenderedImagePushSecretLike(ImageSecretObjectReference item) {
        return new RenderedImagePushSecretNested(item);
    }

    public RenderedImagePushSecretNested<A> editRenderedImagePushSecret() {
        return this.withNewRenderedImagePushSecretLike(Optional.ofNullable(this.buildRenderedImagePushSecret()).orElse(null));
    }

    public RenderedImagePushSecretNested<A> editOrNewRenderedImagePushSecret() {
        return this.withNewRenderedImagePushSecretLike(Optional.ofNullable(this.buildRenderedImagePushSecret()).orElse(new ImageSecretObjectReferenceBuilder().build()));
    }

    public RenderedImagePushSecretNested<A> editOrNewRenderedImagePushSecretLike(ImageSecretObjectReference item) {
        return this.withNewRenderedImagePushSecretLike(Optional.ofNullable(this.buildRenderedImagePushSecret()).orElse(item));
    }

    public String getRenderedImagePushSpec() {
        return this.renderedImagePushSpec;
    }

    public A withRenderedImagePushSpec(String renderedImagePushSpec) {
        this.renderedImagePushSpec = renderedImagePushSpec;
        return (A)((Object)this);
    }

    public boolean hasRenderedImagePushSpec() {
        return this.renderedImagePushSpec != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineOSConfigSpecFluent that = (MachineOSConfigSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.baseImagePullSecret, (Object)that.baseImagePullSecret)) {
            return false;
        }
        if (!Objects.equals(this.containerFile, that.containerFile)) {
            return false;
        }
        if (!Objects.equals((Object)this.imageBuilder, (Object)that.imageBuilder)) {
            return false;
        }
        if (!Objects.equals((Object)this.machineConfigPool, (Object)that.machineConfigPool)) {
            return false;
        }
        if (!Objects.equals((Object)this.renderedImagePushSecret, (Object)that.renderedImagePushSecret)) {
            return false;
        }
        if (!Objects.equals(this.renderedImagePushSpec, that.renderedImagePushSpec)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseImagePullSecret, this.containerFile, this.imageBuilder, this.machineConfigPool, this.renderedImagePushSecret, this.renderedImagePushSpec, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImagePullSecret != null) {
            sb.append("baseImagePullSecret:");
            sb.append(String.valueOf((Object)this.baseImagePullSecret) + ",");
        }
        if (this.containerFile != null && !this.containerFile.isEmpty()) {
            sb.append("containerFile:");
            sb.append(String.valueOf(this.containerFile) + ",");
        }
        if (this.imageBuilder != null) {
            sb.append("imageBuilder:");
            sb.append(String.valueOf((Object)this.imageBuilder) + ",");
        }
        if (this.machineConfigPool != null) {
            sb.append("machineConfigPool:");
            sb.append(String.valueOf((Object)this.machineConfigPool) + ",");
        }
        if (this.renderedImagePushSecret != null) {
            sb.append("renderedImagePushSecret:");
            sb.append(String.valueOf((Object)this.renderedImagePushSecret) + ",");
        }
        if (this.renderedImagePushSpec != null) {
            sb.append("renderedImagePushSpec:");
            sb.append(this.renderedImagePushSpec + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RenderedImagePushSecretNested<N>
    extends ImageSecretObjectReferenceFluent<RenderedImagePushSecretNested<N>>
    implements Nested<N> {
        ImageSecretObjectReferenceBuilder builder;

        RenderedImagePushSecretNested(ImageSecretObjectReference item) {
            this.builder = new ImageSecretObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSConfigSpecFluent.this.withRenderedImagePushSecret(this.builder.build());
        }

        public N endRenderedImagePushSecret() {
            return this.and();
        }
    }

    public class MachineConfigPoolNested<N>
    extends MachineConfigPoolReferenceFluent<MachineConfigPoolNested<N>>
    implements Nested<N> {
        MachineConfigPoolReferenceBuilder builder;

        MachineConfigPoolNested(MachineConfigPoolReference item) {
            this.builder = new MachineConfigPoolReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSConfigSpecFluent.this.withMachineConfigPool(this.builder.build());
        }

        public N endMachineConfigPool() {
            return this.and();
        }
    }

    public class ImageBuilderNested<N>
    extends MachineOSImageBuilderFluent<ImageBuilderNested<N>>
    implements Nested<N> {
        MachineOSImageBuilderBuilder builder;

        ImageBuilderNested(MachineOSImageBuilder item) {
            this.builder = new MachineOSImageBuilderBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSConfigSpecFluent.this.withImageBuilder(this.builder.build());
        }

        public N endImageBuilder() {
            return this.and();
        }
    }

    public class ContainerFileNested<N>
    extends MachineOSContainerfileFluent<ContainerFileNested<N>>
    implements Nested<N> {
        MachineOSContainerfileBuilder builder;
        int index;

        ContainerFileNested(int index, MachineOSContainerfile item) {
            this.index = index;
            this.builder = new MachineOSContainerfileBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSConfigSpecFluent.this.setToContainerFile(this.index, this.builder.build());
        }

        public N endContainerFile() {
            return this.and();
        }
    }

    public class BaseImagePullSecretNested<N>
    extends ImageSecretObjectReferenceFluent<BaseImagePullSecretNested<N>>
    implements Nested<N> {
        ImageSecretObjectReferenceBuilder builder;

        BaseImagePullSecretNested(ImageSecretObjectReference item) {
            this.builder = new ImageSecretObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSConfigSpecFluent.this.withBaseImagePullSecret(this.builder.build());
        }

        public N endBaseImagePullSecret() {
            return this.and();
        }
    }
}

