/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ConfigResourceStatus;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBinding;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBindingBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigResourceStatusFluent<A extends ConfigResourceStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<WorkloadBindingBuilder> bindings = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ConfigResourceStatusFluent() {
    }

    public ConfigResourceStatusFluent(ConfigResourceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConfigResourceStatus instance) {
        ConfigResourceStatus configResourceStatus = instance = instance != null ? instance : new ConfigResourceStatus();
        if (instance != null) {
            this.withBindings(instance.getBindings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBindings(int index, WorkloadBinding item) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
        if (index < 0 || index >= this.bindings.size()) {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        } else {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBindings(int index, WorkloadBinding item) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
        if (index < 0 || index >= this.bindings.size()) {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        } else {
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBindings(WorkloadBinding ... items) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBindings(Collection<WorkloadBinding> items) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get((Object)"bindings").add(builder);
            this.bindings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBindings(WorkloadBinding ... items) {
        if (this.bindings == null) {
            return (A)((Object)this);
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get((Object)"bindings").remove((Object)builder);
            this.bindings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBindings(Collection<WorkloadBinding> items) {
        if (this.bindings == null) {
            return (A)((Object)this);
        }
        for (WorkloadBinding item : items) {
            WorkloadBindingBuilder builder = new WorkloadBindingBuilder(item);
            this._visitables.get((Object)"bindings").remove((Object)builder);
            this.bindings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBindings(Predicate<WorkloadBindingBuilder> predicate) {
        if (this.bindings == null) {
            return (A)((Object)this);
        }
        Iterator<WorkloadBindingBuilder> each = this.bindings.iterator();
        List visitables = this._visitables.get((Object)"bindings");
        while (each.hasNext()) {
            WorkloadBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<WorkloadBinding> buildBindings() {
        return this.bindings != null ? ConfigResourceStatusFluent.build(this.bindings) : null;
    }

    public WorkloadBinding buildBinding(int index) {
        return this.bindings.get(index).build();
    }

    public WorkloadBinding buildFirstBinding() {
        return this.bindings.get(0).build();
    }

    public WorkloadBinding buildLastBinding() {
        return this.bindings.get(this.bindings.size() - 1).build();
    }

    public WorkloadBinding buildMatchingBinding(Predicate<WorkloadBindingBuilder> predicate) {
        for (WorkloadBindingBuilder item : this.bindings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBinding(Predicate<WorkloadBindingBuilder> predicate) {
        for (WorkloadBindingBuilder item : this.bindings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBindings(List<WorkloadBinding> bindings) {
        if (this.bindings != null) {
            this._visitables.get((Object)"bindings").clear();
        }
        if (bindings != null) {
            this.bindings = new ArrayList();
            for (WorkloadBinding item : bindings) {
                this.addToBindings(item);
            }
        } else {
            this.bindings = null;
        }
        return (A)((Object)this);
    }

    public A withBindings(WorkloadBinding ... bindings) {
        if (this.bindings != null) {
            this.bindings.clear();
            this._visitables.remove((Object)"bindings");
        }
        if (bindings != null) {
            for (WorkloadBinding item : bindings) {
                this.addToBindings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBindings() {
        return this.bindings != null && !this.bindings.isEmpty();
    }

    public BindingsNested<A> addNewBinding() {
        return new BindingsNested(-1, null);
    }

    public BindingsNested<A> addNewBindingLike(WorkloadBinding item) {
        return new BindingsNested(-1, item);
    }

    public BindingsNested<A> setNewBindingLike(int index, WorkloadBinding item) {
        return new BindingsNested(index, item);
    }

    public BindingsNested<A> editBinding(int index) {
        if (this.bindings.size() <= index) {
            throw new RuntimeException("Can't edit bindings. Index exceeds size.");
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public BindingsNested<A> editFirstBinding() {
        if (this.bindings.size() == 0) {
            throw new RuntimeException("Can't edit first bindings. The list is empty.");
        }
        return this.setNewBindingLike(0, this.buildBinding(0));
    }

    public BindingsNested<A> editLastBinding() {
        int index = this.bindings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last bindings. The list is empty.");
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public BindingsNested<A> editMatchingBinding(Predicate<WorkloadBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bindings.size(); ++i) {
            if (!predicate.test(this.bindings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching bindings. No match found.");
        }
        return this.setNewBindingLike(index, this.buildBinding(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigResourceStatusFluent that = (ConfigResourceStatusFluent)((Object)o);
        if (!Objects.equals(this.bindings, that.bindings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.bindings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindings != null && !this.bindings.isEmpty()) {
            sb.append("bindings:");
            sb.append(String.valueOf(this.bindings) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BindingsNested<N>
    extends WorkloadBindingFluent<BindingsNested<N>>
    implements Nested<N> {
        WorkloadBindingBuilder builder;
        int index;

        BindingsNested(int index, WorkloadBinding item) {
            this.index = index;
            this.builder = new WorkloadBindingBuilder(this, item);
        }

        public N and() {
            return (N)ConfigResourceStatusFluent.this.setToBindings(this.index, this.builder.build());
        }

        public N endBinding() {
            return this.and();
        }
    }
}

