/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="AuditAnnotation describes how to produce an audit annotation for an API request.")
public class V1beta1AuditAnnotation {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_VALUE_EXPRESSION = "valueExpression";
    @SerializedName(value="valueExpression")
    @Nonnull
    private String valueExpression;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1AuditAnnotation key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.  The key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".  If an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.  Required.")
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public V1beta1AuditAnnotation valueExpression(@Nonnull String valueExpression) {
        this.valueExpression = valueExpression;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.  If multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.  Required.")
    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(@Nonnull String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1AuditAnnotation v1beta1AuditAnnotation = (V1beta1AuditAnnotation)o;
        return Objects.equals(this.key, v1beta1AuditAnnotation.key) && Objects.equals(this.valueExpression, v1beta1AuditAnnotation.valueExpression);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.valueExpression);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1AuditAnnotation {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    valueExpression: ").append(this.toIndentedString(this.valueExpression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1AuditAnnotation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1AuditAnnotation` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VALUE_EXPRESSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `valueExpression` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE_EXPRESSION).toString()));
        }
    }

    public static V1beta1AuditAnnotation fromJson(String jsonString) throws IOException {
        return (V1beta1AuditAnnotation)JSON.getGson().fromJson(jsonString, V1beta1AuditAnnotation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_VALUE_EXPRESSION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_VALUE_EXPRESSION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1AuditAnnotation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1AuditAnnotation.class));
            return new TypeAdapter<V1beta1AuditAnnotation>(){

                public void write(JsonWriter out, V1beta1AuditAnnotation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1AuditAnnotation read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1AuditAnnotation.validateJsonElement(jsonElement);
                    return (V1beta1AuditAnnotation)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

