/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import io.quarkus.registry.config.ConfigSource;
import io.quarkus.registry.config.RegistriesConfigImpl;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistriesConfigMapperHelper;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public interface RegistriesConfig {
    public boolean isDebug();

    public List<RegistryConfig> getRegistries();

    public ConfigSource getSource();

    default public Mutable mutable() {
        return new RegistriesConfigImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        RegistriesConfigMapperHelper.serialize(this, p);
    }

    public void persist() throws IOException;

    public static RegistriesConfig resolveConfig() {
        return RegistriesConfigLocator.resolveConfig();
    }

    public static RegistriesConfig resolveFromFile(Path configYaml) {
        return RegistriesConfigLocator.load(configYaml);
    }

    public static RegistriesConfig fromFile(Path path) throws IOException {
        return RegistriesConfig.mutableFromFile(path).build();
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        RegistriesConfigImpl.Builder builder = RegistriesConfigMapperHelper.deserialize(path, RegistriesConfigImpl.Builder.class);
        return builder == null ? RegistriesConfig.builder() : builder;
    }

    public static Mutable builder() {
        return new RegistriesConfigImpl.Builder();
    }

    public static interface Mutable
    extends RegistriesConfig,
    JsonBuilder<RegistriesConfig> {
        public Mutable setDebug(boolean var1);

        public Mutable setRegistries(List<RegistryConfig> var1);

        public Mutable setRegistry(String var1);

        public Mutable setRegistry(RegistryConfig var1);

        public boolean addRegistry(String var1);

        public boolean addRegistry(RegistryConfig var1);

        public boolean removeRegistry(String var1);

        @Override
        public RegistriesConfig build();

        @Override
        default public void persist(Path p) throws IOException {
            RegistriesConfigMapperHelper.serialize(this.build(), p);
        }
    }
}

