/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfigBuilder;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@ConfigGroup
public interface KeycloakPolicyEnforcerTenantConfig {
    @WithDefault(value="20")
    public int connectionPoolSize();

    public KeycloakConfigPolicyEnforcer policyEnforcer();

    public static KeycloakPolicyEnforcerTenantConfigBuilder builder() {
        KeycloakPolicyEnforcerTenantConfig defaultTenantConfig = ((KeycloakPolicyEnforcerConfig)new SmallRyeConfigBuilder().withMapping(KeycloakPolicyEnforcerConfig.class).build().getConfigMapping(KeycloakPolicyEnforcerConfig.class)).defaultTenant();
        return new KeycloakPolicyEnforcerTenantConfigBuilder(defaultTenantConfig);
    }

    public static KeycloakPolicyEnforcerTenantConfigBuilder builder(KeycloakPolicyEnforcerTenantConfig tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        return new KeycloakPolicyEnforcerTenantConfigBuilder(tenantConfig);
    }

    @ConfigGroup
    public static interface KeycloakConfigPolicyEnforcer {
        @WithDefault(value="enforcing")
        public PolicyEnforcerConfig.EnforcementMode enforcementMode();

        public Map<String, PathConfig> paths();

        public PathCacheConfig pathCache();

        @WithDefault(value="true")
        public boolean lazyLoadPaths();

        public ClaimInformationPointConfig claimInformationPoint();

        @WithDefault(value="false")
        public boolean httpMethodAsScope();

        @ConfigGroup
        public static interface ClaimInformationPointConfig {
            @WithParentName
            public Map<String, Map<String, Map<String, String>>> complexConfig();

            @WithParentName
            public Map<String, Map<String, String>> simpleConfig();
        }

        @ConfigGroup
        public static interface PathCacheConfig {
            @WithDefault(value="1000")
            public int maxEntries();

            @WithDefault(value="30000")
            public long lifespan();
        }

        @ConfigGroup
        public static interface MethodConfig {
            public String method();

            public List<String> scopes();

            @WithDefault(value="all")
            public PolicyEnforcerConfig.ScopeEnforcementMode scopesEnforcementMode();
        }

        @ConfigGroup
        public static interface PathConfig {
            public Optional<String> name();

            @Deprecated(since="Quarkus 3.10")
            public Optional<String> path();

            public Optional<List<String>> paths();

            public Map<String, MethodConfig> methods();

            @WithDefault(value="enforcing")
            public PolicyEnforcerConfig.EnforcementMode enforcementMode();

            public ClaimInformationPointConfig claimInformationPoint();
        }
    }
}

