/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.IngressRuleBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddIngressRuleDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.project.Project;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.spi.KubernetesClientCapabilityBuildItem;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.IngressConfig;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.RemovePortFromServiceDecorator;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEffectiveServiceAccountBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesInitContainerBuildItem;
import io.quarkus.kubernetes.spi.KubernetesJobBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesNamespaceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesProbePortNameBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.Targetable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class DevClusterHelper {
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-256";

    public static List<DecoratorBuildItem> createDecorators(String clusterKind, String deploymentTarget, ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, KubernetesConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, Optional<KubernetesClientCapabilityBuildItem> kubernetesClientConfiguration, List<KubernetesNamespaceBuildItem> namespaces, List<KubernetesInitContainerBuildItem> initContainers, List<KubernetesJobBuildItem> jobs, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, @Deprecated Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesProbePortNameBuildItem> portName, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, Optional<KubernetesHealthStartupPathBuildItem> startupPath, List<KubernetesRoleBuildItem> roles, List<KubernetesClusterRoleBuildItem> clusterRoles, List<KubernetesEffectiveServiceAccountBuildItem> serviceAccounts, List<KubernetesRoleBindingBuildItem> roleBindings, List<KubernetesClusterRoleBindingBuildItem> clusterRoleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot) {
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<KubernetesNamespaceBuildItem> namespace = Targetable.filteredByTarget(namespaces, (String)deploymentTarget, (boolean)true).findFirst();
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        Optional<Port> port = KubernetesCommonHelper.getPort(ports, config);
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>(KubernetesCommonHelper.createDecorators(project, clusterKind, name, namespace, config, metricsConfiguration, kubernetesClientConfiguration, annotations, labels, image, command, port, livenessPath, readinessPath, startupPath, roles, clusterRoles, serviceAccounts, roleBindings, clusterRoleBindings));
        image.ifPresent(i -> result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        Stream<KubernetesEnvBuildItem> stream = Stream.concat(config.convertToBuildItems().stream(), Targetable.filteredByTarget(envs, (String)"kubernetes"));
        if (config.idempotent()) {
            stream = stream.sorted(Comparator.comparing(e -> EnvConverter.convertName(e.getName())));
        }
        stream.forEach(e -> result.add(new DecoratorBuildItem(clusterKind, (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).withPrefix(e.getPrefix())).build()))));
        result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyImagePullPolicyDecorator(name, "IfNotPresent")));
        result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyServiceTypeDecorator(name, ServiceType.NodePort.name())));
        List<Map.Entry> nodeConfigPorts = config.ports().entrySet().stream().filter(e -> ((PortConfig)e.getValue()).nodePort().isPresent()).toList();
        if (!nodeConfigPorts.isEmpty()) {
            for (Map.Entry entry : nodeConfigPorts) {
                result.add(new DecoratorBuildItem("kubernetes", (Object)new AddNodePortDecorator(name, ((PortConfig)entry.getValue()).nodePort().getAsInt(), (String)entry.getKey())));
            }
        } else {
            result.add(new DecoratorBuildItem(clusterKind, (Object)new AddNodePortDecorator(name, config.nodePort().orElseGet(() -> DevClusterHelper.getStablePortNumberInRange(name, 30000, 31999)), config.ingress().targetPort())));
        }
        result.add(KubernetesCommonHelper.createProbeHttpPortDecorator(name, clusterKind, "livenessProbe", config.livenessProbe(), portName, ports, config.ports()));
        result.add(KubernetesCommonHelper.createProbeHttpPortDecorator(name, clusterKind, "readinessProbe", config.readinessProbe(), portName, ports, config.ports()));
        result.add(KubernetesCommonHelper.createProbeHttpPortDecorator(name, clusterKind, "startupProbe", config.startupProbe(), portName, ports, config.ports()));
        for (Map.Entry entry : config.ingress().annotations().entrySet()) {
            result.add(new DecoratorBuildItem(clusterKind, (Object)new AddAnnotationDecorator(name, (String)entry.getKey(), (String)entry.getValue(), new String[]{"Ingress"})));
        }
        for (IngressConfig.IngressRuleConfig ingressRuleConfig : config.ingress().rules().values()) {
            result.add(new DecoratorBuildItem(clusterKind, (Object)new AddIngressRuleDecorator(name, port, ((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)new IngressRuleBuilder().withHost(ingressRuleConfig.host())).withPath(ingressRuleConfig.path())).withPathType(ingressRuleConfig.pathType())).withServiceName((String)ingressRuleConfig.serviceName().orElse(null))).withServicePortName((String)ingressRuleConfig.servicePortName().orElse(null))).withServicePortNumber(ingressRuleConfig.servicePortNumber().orElse(-1))).build())));
        }
        result.addAll(KubernetesCommonHelper.createInitContainerDecorators(clusterKind, name, initContainers, result));
        result.addAll(KubernetesCommonHelper.createInitJobDecorators(clusterKind, name, jobs, result));
        if (!(!KubernetesConfigUtil.managementPortIsEnabled() || config.ingress() != null && config.ingress().expose() && config.ingress().targetPort().equals("management"))) {
            result.add(new DecoratorBuildItem(clusterKind, (Object)new RemovePortFromServiceDecorator(name, "management")));
        }
        return result;
    }

    private static int getStablePortNumberInRange(String input, int min, int max) {
        if (min < 1 || max > 65535) {
            throw new IllegalArgumentException(String.format("Port number range must be within [%d-%d]", 1, 65535));
        }
        try {
            byte[] hash = MessageDigest.getInstance(DEFAULT_HASH_ALGORITHM).digest(input.getBytes(StandardCharsets.UTF_8));
            return min + new BigInteger(hash).mod(BigInteger.valueOf(max - min)).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate stable port number from input string: '" + input + "'", e);
        }
    }
}

