/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Optional;

public interface ProbeConfig {
    public Optional<Integer> httpActionPort();

    public Optional<String> httpActionPortName();

    public Optional<String> httpActionPath();

    public Optional<String> httpActionScheme();

    public Optional<String> execAction();

    public Optional<String> tcpSocketAction();

    public Optional<String> grpcAction();

    @WithDefault(value="false")
    public boolean grpcActionEnabled();

    @WithDefault(value="5")
    public Duration initialDelay();

    @WithDefault(value="10s")
    public Duration period();

    @WithDefault(value="10s")
    public Duration timeout();

    @WithDefault(value="1")
    public Integer successThreshold();

    @WithDefault(value="3")
    public Integer failureThreshold();

    default public boolean hasUserSuppliedAction() {
        return this.httpActionPath().isPresent() || this.tcpSocketAction().isPresent() || this.execAction().isPresent() || this.grpcAction().isPresent();
    }
}

