/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;
import net.logstash.logback.encoder.com.lmax.disruptor.AbstractSequencer;
import net.logstash.logback.encoder.com.lmax.disruptor.InsufficientCapacityException;
import net.logstash.logback.encoder.com.lmax.disruptor.Sequence;
import net.logstash.logback.encoder.com.lmax.disruptor.WaitStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.util.Util;

public final class MultiProducerSequencer
extends AbstractSequencer {
    private static final VarHandle AVAILABLE_ARRAY = MethodHandles.arrayElementVarHandle(int[].class);
    private final Sequence gatingSequenceCache = new Sequence(-1L);
    private final int[] availableBuffer;
    private final int indexMask;
    private final int indexShift;

    public MultiProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        super(bufferSize, waitStrategy);
        this.availableBuffer = new int[bufferSize];
        Arrays.fill(this.availableBuffer, -1);
        this.indexMask = bufferSize - 1;
        this.indexShift = Util.log2(bufferSize);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.hasAvailableCapacity(this.gatingSequences, requiredCapacity, this.cursor.get());
    }

    private boolean hasAvailableCapacity(Sequence[] gatingSequences, int requiredCapacity, long cursorValue) {
        long wrapPoint = cursorValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.get();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > cursorValue) {
            long minSequence = Util.getMinimumSequence(gatingSequences, cursorValue);
            this.gatingSequenceCache.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void claim(long sequence) {
        this.cursor.set(sequence);
    }

    @Override
    public long next() {
        return this.next(1);
    }

    @Override
    public long next(int n) {
        long cachedGatingSequence;
        if (n < 1 || n > this.bufferSize) {
            throw new IllegalArgumentException("n must be > 0 and < bufferSize");
        }
        long current = this.cursor.getAndAdd(n);
        long nextSequence = current + (long)n;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        if (wrapPoint > (cachedGatingSequence = this.gatingSequenceCache.get()) || cachedGatingSequence > current) {
            long gatingSequence;
            while (wrapPoint > (gatingSequence = Util.getMinimumSequence(this.gatingSequences, current))) {
                LockSupport.parkNanos(1L);
            }
            this.gatingSequenceCache.set(gatingSequence);
        }
        return nextSequence;
    }

    @Override
    public long tryNext() throws InsufficientCapacityException {
        return this.tryNext(1);
    }

    @Override
    public long tryNext(int n) throws InsufficientCapacityException {
        long next;
        long current;
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        do {
            current = this.cursor.get();
            next = current + (long)n;
            if (this.hasAvailableCapacity(this.gatingSequences, n, current)) continue;
            throw InsufficientCapacityException.INSTANCE;
        } while (!this.cursor.compareAndSet(current, next));
        return next;
    }

    @Override
    public long remainingCapacity() {
        long consumed = Util.getMinimumSequence(this.gatingSequences, this.cursor.get());
        long produced = this.cursor.get();
        return (long)this.getBufferSize() - (produced - consumed);
    }

    @Override
    public void publish(long sequence) {
        this.setAvailable(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        for (long l = lo; l <= hi; ++l) {
            this.setAvailable(l);
        }
        this.waitStrategy.signalAllWhenBlocking();
    }

    private void setAvailable(long sequence) {
        this.setAvailableBufferValue(this.calculateIndex(sequence), this.calculateAvailabilityFlag(sequence));
    }

    private void setAvailableBufferValue(int index, int flag) {
        AVAILABLE_ARRAY.setRelease(this.availableBuffer, index, flag);
    }

    @Override
    public boolean isAvailable(long sequence) {
        int index = this.calculateIndex(sequence);
        int flag = this.calculateAvailabilityFlag(sequence);
        return AVAILABLE_ARRAY.getAcquire(this.availableBuffer, index) == flag;
    }

    @Override
    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        for (long sequence = lowerBound; sequence <= availableSequence; ++sequence) {
            if (this.isAvailable(sequence)) continue;
            return sequence - 1L;
        }
        return availableSequence;
    }

    private int calculateAvailabilityFlag(long sequence) {
        return (int)(sequence >>> this.indexShift);
    }

    private int calculateIndex(long sequence) {
        return (int)sequence & this.indexMask;
    }

    @Override
    public String toString() {
        return "MultiProducerSequencer{bufferSize=" + this.bufferSize + ", waitStrategy=" + this.waitStrategy + ", cursor=" + this.cursor + ", gatingSequences=" + Arrays.toString(this.gatingSequences) + "}";
    }
}

