/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.logstash.logback.composite.JsonReadingUtils;
import net.logstash.logback.pattern.NodeWriter;
import net.logstash.logback.pattern.PatternLayoutAdapter;
import net.logstash.logback.pattern.ValueGetter;
import net.logstash.logback.util.StringUtils;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.filter.FilteringGeneratorDelegate;
import tools.jackson.core.filter.TokenFilter;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public abstract class AbstractJsonPatternParser<Event> {
    public static final Pattern OPERATION_PATTERN = Pattern.compile("\\# (\\w+) (?: \\{ (.*) \\} )", 4);
    private final Context context;
    private final ObjectMapper objectMapper;
    private final Map<String, Operation<?>> operations = new HashMap();
    private boolean omitEmptyFields;

    AbstractJsonPatternParser(Context context, ObjectMapper objectMapper) {
        this.context = Objects.requireNonNull(context);
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.addOperation("asLong", new AsLongOperation());
        this.addOperation("asDouble", new AsDoubleOperation());
        this.addOperation("asBoolean", new AsBooleanOperation());
        this.addOperation("asJson", new AsJsonOperation());
        this.addOperation("tryJson", new TryJsonOperation());
        this.addOperation("asNullIfEmpty", new AsNullIfEmptyOperation());
    }

    protected void addOperation(String name, Operation<?> operation) {
        this.operations.put(name, operation);
    }

    private ValueGetter<Event, ?> makeComputableValueGetter(String pattern) {
        Matcher matcher = OPERATION_PATTERN.matcher(pattern);
        if (matcher.matches()) {
            String operationName = matcher.group(1);
            String operationData = matcher.groupCount() > 1 ? matcher.group(2) : null;
            Operation<?> operation = this.operations.get(operationName);
            if (operation == null) {
                throw new IllegalArgumentException("Unknown operation '#" + operationName + "{}'");
            }
            ValueGetter layoutValueGetter = this.makeLayoutValueGetter(operationData);
            return event -> operation.apply((String)layoutValueGetter.getValue(event));
        }
        if (pattern != null && pattern.startsWith("\\#")) {
            pattern = pattern.substring(1);
        }
        return this.makeLayoutValueGetter(pattern);
    }

    protected ValueGetter<Event, String> makeLayoutValueGetter(String data) {
        if (StringUtils.isEmpty(data)) {
            return g -> "";
        }
        PatternLayoutAdapter<Event> layout = this.buildLayout(data);
        if (layout.isConstant()) {
            String constantValue = layout.getConstantValue();
            return g -> constantValue;
        }
        return new LayoutValueGetter<Event>(layout);
    }

    protected PatternLayoutAdapter<Event> buildLayout(String format) {
        PatternLayoutAdapter<Event> adapter = new PatternLayoutAdapter<Event>(this.createLayout());
        adapter.setPattern(format);
        adapter.setContext(this.context);
        adapter.start();
        return adapter;
    }

    protected abstract PatternLayoutBase<Event> createLayout();

    public NodeWriter<Event> parse(String pattern) throws JsonPatternException {
        ObjectNode node;
        if (StringUtils.isEmpty(pattern)) {
            return null;
        }
        try {
            node = JsonReadingUtils.readFullyAsObjectNode(this.objectMapper, pattern);
        }
        catch (StreamReadException e) {
            throw new JsonPatternException("pattern is not a valid JSON object", e);
        }
        NodeWriter<Event> nodeWriter = new RootWriter<Event>(this.parseObject(JsonPointer.compile((String)"/"), node));
        if (this.omitEmptyFields) {
            nodeWriter = new OmitEmptyFieldWriter<Event>(nodeWriter);
        }
        return nodeWriter;
    }

    private NodeWriter<Event> parseNode(JsonPointer location, JsonNode node) throws JsonPatternException {
        if (node.isString()) {
            try {
                ValueGetter<Event, ?> getter = this.makeComputableValueGetter(node.asString());
                return new ValueWriter<Event>(getter);
            }
            catch (RuntimeException e) {
                String msg = "Invalid JSON property '" + String.valueOf(location) + "' (was '" + node.asString() + "'): " + e.getMessage();
                throw new JsonPatternException(msg, e);
            }
        }
        if (node.isArray()) {
            return this.parseArray(location, (ArrayNode)node);
        }
        if (node.isObject()) {
            return this.parseObject(location, (ObjectNode)node);
        }
        return new ValueWriter<Object>(g -> node);
    }

    private ArrayWriter<Event> parseArray(JsonPointer location, ArrayNode node) throws JsonPatternException {
        ArrayList children = new ArrayList();
        int index = 0;
        for (JsonNode item : node) {
            children.add(this.parseNode(AbstractJsonPatternParser.appendPath(location, Integer.toString(index++)), item));
        }
        return new ArrayWriter(children);
    }

    private ObjectWriter<Event> parseObject(JsonPointer location, ObjectNode node) throws JsonPatternException {
        ObjectWriter<Event> writer = new ObjectWriter<Event>();
        for (Map.Entry property : node.properties()) {
            String propertyName = (String)property.getKey();
            JsonNode propertyValue = (JsonNode)property.getValue();
            NodeWriter<Event> fieldWriter = this.parseNode(AbstractJsonPatternParser.appendPath(location, propertyName), propertyValue);
            writer.addField(propertyName, fieldWriter);
        }
        return writer;
    }

    private static JsonPointer appendPath(JsonPointer ptr, String path) {
        return ptr.append(JsonPointer.compile((String)("/" + path)));
    }

    public boolean isOmitEmptyFields() {
        return this.omitEmptyFields;
    }

    public void setOmitEmptyFields(boolean omitEmptyFields) {
        this.omitEmptyFields = omitEmptyFields;
    }

    protected static class AsLongOperation
    implements Operation<Long> {
        protected AsLongOperation() {
        }

        @Override
        public Long apply(String value) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to convert '" + value + "' into a Long numeric value");
            }
        }
    }

    protected static interface Operation<T>
    extends Function<String, T> {
    }

    protected static class AsDoubleOperation
    implements Operation<Double> {
        protected AsDoubleOperation() {
        }

        @Override
        public Double apply(String value) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to convert '" + value + "' into a Double numeric value");
            }
        }
    }

    protected static class AsBooleanOperation
    implements Operation<Boolean> {
        protected AsBooleanOperation() {
        }

        @Override
        public Boolean apply(String value) {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            return "true".equalsIgnoreCase(value) || "1".equals(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value);
        }
    }

    protected class AsJsonOperation
    implements Operation<JsonNode> {
        protected AsJsonOperation() {
        }

        @Override
        public JsonNode apply(String value) {
            try {
                return JsonReadingUtils.readFully(AbstractJsonPatternParser.this.objectMapper, value);
            }
            catch (StreamReadException e) {
                throw new IllegalArgumentException("Failed to convert '" + value + "' into a JSON object", e);
            }
        }
    }

    protected class TryJsonOperation
    implements Operation<Object> {
        protected TryJsonOperation() {
        }

        @Override
        public Object apply(String value) {
            try {
                return JsonReadingUtils.readFully(AbstractJsonPatternParser.this.objectMapper, value);
            }
            catch (StreamReadException e) {
                return value;
            }
        }
    }

    protected class AsNullIfEmptyOperation
    implements Operation<Object> {
        protected AsNullIfEmptyOperation() {
        }

        @Override
        public Object apply(String t) {
            return StringUtils.isEmpty(t) ? null : t;
        }
    }

    protected static class LayoutValueGetter<Event>
    implements ValueGetter<Event, String> {
        private final PatternLayoutAdapter<Event> layout;
        private static final ThreadLocal<StringBuilder> STRING_BUILDERS = ThreadLocal.withInitial(StringBuilder::new);
        private static final int MAX_RECYCLABLE_SIZE = 1024;

        LayoutValueGetter(PatternLayoutAdapter<Event> layout) {
            this.layout = layout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getValue(Event event) {
            StringBuilder strBuilder = STRING_BUILDERS.get();
            try {
                this.layout.writeTo(strBuilder, event);
                String string = strBuilder.toString();
                return string;
            }
            finally {
                if (strBuilder.length() <= 1024) {
                    strBuilder.setLength(0);
                } else {
                    STRING_BUILDERS.remove();
                }
            }
        }
    }

    public static class JsonPatternException
    extends Exception {
        public JsonPatternException(String message, Throwable cause) {
            super(message, cause);
        }

        public JsonPatternException(String message) {
            super(message);
        }
    }

    private static class RootWriter<Event>
    implements NodeWriter<Event> {
        private final ObjectWriter<Event> delegate;

        RootWriter(ObjectWriter<Event> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void write(JsonGenerator generator, Event event) {
            this.delegate.writeFields(generator, event);
        }
    }

    protected static class ObjectWriter<Event>
    implements NodeWriter<Event> {
        private final List<Field<Event>> fields = new ArrayList<Field<Event>>();

        protected ObjectWriter() {
        }

        public void addField(String fieldName, NodeWriter<Event> fieldValue) {
            this.fields.add(new Field<Event>(fieldName, fieldValue));
        }

        @Override
        public void write(JsonGenerator generator, Event event) {
            generator.writeStartObject();
            this.writeFields(generator, event);
            generator.writeEndObject();
        }

        protected void writeFields(JsonGenerator generator, Event event) {
            for (Field<Event> field : this.fields) {
                field.write(generator, event);
            }
        }

        private static class Field<E> {
            private final String name;
            private final NodeWriter<E> writer;

            Field(String name, NodeWriter<E> writer) {
                this.name = name;
                this.writer = writer;
            }

            public void write(JsonGenerator generator, E event) {
                generator.writeName(this.name);
                this.writer.write(generator, event);
            }
        }
    }

    private static class OmitEmptyFieldWriter<Event>
    implements NodeWriter<Event> {
        private static final ThreadLocal<ReusableFilteringGenerator> filteringGenerators = ThreadLocal.withInitial(ReusableFilteringGenerator::new);
        private final NodeWriter<Event> delegate;

        OmitEmptyFieldWriter(NodeWriter<Event> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void write(JsonGenerator generator, Event event) {
            ReusableFilteringGenerator filteringGenerator = filteringGenerators.get();
            try {
                filteringGenerator.connect(generator);
                this.delegate.write((JsonGenerator)filteringGenerator, event);
            }
            catch (RuntimeException e) {
                filteringGenerators.remove();
                throw e;
            }
            finally {
                filteringGenerator.disconnect();
            }
        }
    }

    protected static class ValueWriter<Event>
    implements NodeWriter<Event> {
        private final ValueGetter<Event, ?> getter;

        ValueWriter(ValueGetter<Event, ?> getter) {
            this.getter = getter;
        }

        @Override
        public void write(JsonGenerator generator, Event event) {
            generator.writePOJO(this.getValue(event));
        }

        private Object getValue(Event event) {
            try {
                return this.getter.getValue(event);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    protected static class ArrayWriter<Event>
    implements NodeWriter<Event> {
        private final List<NodeWriter<Event>> items;

        ArrayWriter(List<NodeWriter<Event>> items) {
            this.items = items;
        }

        @Override
        public void write(JsonGenerator generator, Event event) {
            generator.writeStartArray();
            for (NodeWriter<Event> item : this.items) {
                item.write(generator, event);
            }
            generator.writeEndArray();
        }
    }

    private static class NullExcludingTokenFilter
    extends TokenFilter {
        private static final NullExcludingTokenFilter INSTANCE = new NullExcludingTokenFilter();

        private NullExcludingTokenFilter() {
        }

        public boolean includeNull() {
            return false;
        }

        public boolean includeString(String value) {
            return !StringUtils.isEmpty(value);
        }
    }

    private static class ReusableFilteringGenerator
    extends FilteringGeneratorDelegate {
        ReusableFilteringGenerator() {
            super(null, (TokenFilter)NullExcludingTokenFilter.INSTANCE, TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH, true);
        }

        public void connect(JsonGenerator generator) {
            this.delegate = generator;
        }

        public void disconnect() {
            this.delegate = null;
        }
    }
}

