/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.BooleanValue;

public class Exists
extends Aggregate {
    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        VennExpression v;
        int c = arguments[0].getCardinality();
        if (c == 49152) {
            return Literal.makeLiteral(BooleanValue.TRUE, arguments[0]);
        }
        if (c == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE, arguments[0]);
        }
        Expression unorderedArg0 = arguments[0].unordered(false, visitor.isOptimizeForStreaming());
        if (unorderedArg0 != arguments[0]) {
            return this.makeFunctionCall(unorderedArg0);
        }
        if (arguments[0] instanceof VennExpression && !visitor.isOptimizeForStreaming() && (v = (VennExpression)arguments[0]).getOperator() == 1) {
            Expression e0 = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), v.getLhsExpression());
            Expression e1 = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), v.getRhsExpression());
            return new OrExpression(e0, e1).optimize(visitor, contextInfo);
        }
        return null;
    }

    private static boolean exists(SequenceIterator iter) {
        boolean result = iter instanceof LookaheadIterator && ((LookaheadIterator)iter).supportsHasNext() ? ((LookaheadIterator)iter).hasNext() : iter.next() != null;
        iter.close();
        return result;
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return BooleanValue.get(Exists.exists(arguments[0].iterate()));
    }

    @Override
    public String getStreamerName() {
        return "Exists";
    }

    @Override
    public Elaborator getElaborator() {
        return new ExistsFnElaborator();
    }

    private static class ExistsFnElaborator
    extends BooleanElaborator {
        private ExistsFnElaborator() {
        }

        @Override
        public BooleanEvaluator elaborateForBoolean() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            PullEvaluator puller = arg.makeElaborator().elaborateForPull();
            return context -> Exists.exists(puller.iterate(context));
        }
    }
}

