/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.z.IntBlockSet;
import net.sf.saxon.z.IntSet;

public class UnicodeBlocks {
    private static Map<String, IntSet> blocks = null;

    public static IntSet getBlock(String name) throws RESyntaxException {
        IntSet cc;
        if (blocks == null) {
            UnicodeBlocks.readBlocks(new Configuration());
        }
        if ((cc = blocks.get(name)) != null) {
            return cc;
        }
        cc = blocks.get(UnicodeBlocks.normalizeBlockName(name));
        return cc;
    }

    private static String normalizeBlockName(String name) {
        StringBuilder fsb = new StringBuilder(name.length());
        block3: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '_': {
                    continue block3;
                }
                default: {
                    fsb.append(c);
                }
            }
        }
        return fsb.toString();
    }

    private static synchronized void readBlocks(Configuration config) throws RESyntaxException {
        NodeInfo item;
        TreeInfo doc;
        blocks = new HashMap<String, IntSet>(250);
        InputStream in = Version.platform.locateResource("unicodeBlocks.xml", new ArrayList<String>());
        if (in == null) {
            throw new RESyntaxException("Unable to read unicodeBlocks.xml file");
        }
        ParseOptions options = new ParseOptions().withSchemaValidationMode(4).withDTDValidationMode(4).withSpaceStrippingRule(AllElementsSpaceStrippingRule.getInstance()).withPleaseCloseAfterUse(true);
        try {
            doc = config.buildDocumentTree(new StreamSource(in, "unicodeBlocks.xml"), options);
        }
        catch (XPathException e) {
            throw new RESyntaxException("Failed to process unicodeBlocks.xml: " + e.getMessage());
        }
        AxisIterator iter = doc.getRootNode().iterateAxis(4, new NameTest(1, NamespaceUri.NULL, "block", config.getNamePool()));
        while ((item = iter.next()) != null) {
            String blockName = UnicodeBlocks.normalizeBlockName(item.getAttributeValue(NamespaceUri.NULL, "name"));
            IntSet range = null;
            for (NodeInfo nodeInfo : item.children(NodeKindTest.ELEMENT)) {
                int from = Integer.parseInt(nodeInfo.getAttributeValue(NamespaceUri.NULL, "from").substring(2), 16);
                int to = Integer.parseInt(nodeInfo.getAttributeValue(NamespaceUri.NULL, "to").substring(2), 16);
                IntBlockSet cr = new IntBlockSet(from, to);
                if (range == null) {
                    range = cr;
                    continue;
                }
                if (range instanceof IntBlockSet) {
                    range = ((IntSet)range).mutableCopy().union(cr);
                    continue;
                }
                range = range.union(cr);
            }
            blocks.put(blockName, range);
        }
    }
}

