/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.cache.internal.FileAnalysisCache;
import net.sourceforge.pmd.cache.internal.NoopAnalysisCache;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.LoggerFactory;

public class PMDConfiguration
extends AbstractConfiguration {
    private static final LanguageRegistry DEFAULT_REGISTRY = LanguageRegistry.PMD;
    public static final String DEFAULT_SUPPRESS_MARKER = "NOPMD";
    private Path reportFile;
    private String suppressMarker = "NOPMD";
    private int threads = Runtime.getRuntime().availableProcessors();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private List<String> ruleSets = new ArrayList<String>();
    private RulePriority minimumPriority = RulePriority.LOW;
    private String reportFormat;
    private Properties reportProperties = new Properties();
    private boolean showSuppressedViolations = false;
    private boolean failOnViolation = true;
    private AnalysisCache analysisCache = new NoopAnalysisCache();
    private boolean ignoreIncrementalAnalysis;

    public PMDConfiguration() {
        this(DEFAULT_REGISTRY);
    }

    public PMDConfiguration(@NonNull LanguageRegistry languageRegistry) {
        super(languageRegistry, new SimpleMessageReporter(LoggerFactory.getLogger(PmdAnalysis.class)));
    }

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public void setSuppressMarker(String suppressMarker) {
        Objects.requireNonNull(suppressMarker, "Suppress marker was null");
        this.suppressMarker = suppressMarker;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    public void prependAuxClasspath(String classpath) {
        try {
            if (this.classLoader == null) {
                this.classLoader = PMDConfiguration.class.getClassLoader();
            }
            if (classpath != null) {
                this.classLoader = new ClasspathClassLoader(classpath, this.classLoader);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public @NonNull List<@NonNull String> getRuleSetPaths() {
        return this.ruleSets;
    }

    public void setRuleSets(@NonNull List<@NonNull String> ruleSetPaths) {
        AssertionUtil.requireParamNotNull("ruleSetPaths", ruleSetPaths);
        AssertionUtil.requireContainsNoNullValue("ruleSetPaths", ruleSetPaths);
        this.ruleSets = new ArrayList<String>(ruleSetPaths);
    }

    public void addRuleSet(@NonNull String rulesetPath) {
        AssertionUtil.requireParamNotNull("rulesetPath", rulesetPath);
        this.ruleSets.add(rulesetPath);
    }

    public RulePriority getMinimumPriority() {
        return this.minimumPriority;
    }

    public void setMinimumPriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
    }

    public Renderer createRenderer() {
        return this.createRenderer(false);
    }

    public Renderer createRenderer(boolean withReportWriter) {
        Renderer renderer = RendererFactory.createRenderer(this.reportFormat, this.reportProperties);
        renderer.setShowSuppressedViolations(this.showSuppressedViolations);
        if (withReportWriter) {
            renderer.setReportFile(this.getReportFilePath() != null ? this.getReportFilePath().toString() : null);
        }
        return renderer;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    public Properties getReportProperties() {
        return this.reportProperties;
    }

    public void setReportProperties(Properties reportProperties) {
        this.reportProperties = reportProperties;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    AnalysisCache getAnalysisCache() {
        if (this.analysisCache == null || this.isIgnoreIncrementalAnalysis() && !(this.analysisCache instanceof NoopAnalysisCache)) {
            this.setAnalysisCache(new NoopAnalysisCache());
        }
        return this.analysisCache;
    }

    void setAnalysisCache(AnalysisCache cache) {
        this.analysisCache = cache == null ? new NoopAnalysisCache() : cache;
    }

    public void setAnalysisCacheLocation(String cacheLocation) {
        this.setAnalysisCache(cacheLocation == null ? new NoopAnalysisCache() : new FileAnalysisCache(new File(cacheLocation)));
    }

    public void setIgnoreIncrementalAnalysis(boolean noCache) {
        this.ignoreIncrementalAnalysis = noCache;
    }

    public boolean isIgnoreIncrementalAnalysis() {
        return this.ignoreIncrementalAnalysis;
    }

    public Path getReportFilePath() {
        return this.reportFile;
    }

    public void setReportFile(Path reportFile) {
        this.reportFile = reportFile;
    }
}

