/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.cache.internal.AnalysisCache;
import net.sourceforge.pmd.cache.internal.AnalysisResult;
import net.sourceforge.pmd.cache.internal.CachedRuleMapper;
import net.sourceforge.pmd.cache.internal.ClasspathFingerprinter;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.internal.RuleSets;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAnalysisCache
implements AnalysisCache {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAnalysisCache.class);
    protected static final ClasspathFingerprinter FINGERPRINTER = new ClasspathFingerprinter();
    protected final String pmdVersion;
    protected final ConcurrentMap<FileId, AnalysisResult> fileResultsCache = new ConcurrentHashMap<FileId, AnalysisResult>();
    protected final ConcurrentMap<FileId, AnalysisResult> updatedResultsCache = new ConcurrentHashMap<FileId, AnalysisResult>();
    protected final CachedRuleMapper ruleMapper = new CachedRuleMapper();
    protected long rulesetChecksum;
    protected long auxClassPathChecksum;
    protected long executionClassPathChecksum;

    AbstractAnalysisCache() {
        this.pmdVersion = PMDVersion.VERSION;
    }

    @Override
    public boolean isUpToDate(TextDocument document) {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.ANALYSIS_CACHE, "up-to-date check");){
            AnalysisResult updatedResult;
            boolean upToDate;
            AnalysisResult cachedResult = (AnalysisResult)this.fileResultsCache.get(document.getFileId());
            boolean bl = upToDate = cachedResult != null && cachedResult.getFileChecksum() == document.getCheckSum();
            if (upToDate) {
                LOG.trace("Incremental Analysis cache HIT");
                updatedResult = cachedResult;
            } else {
                LOG.trace("Incremental Analysis cache MISS - {}", (Object)(cachedResult != null ? "file changed" : "no previous result found"));
                updatedResult = new AnalysisResult(document.getCheckSum(), new ArrayList<RuleViolation>());
            }
            this.updatedResultsCache.put(document.getFileId(), updatedResult);
            boolean bl2 = upToDate;
            return bl2;
        }
    }

    @Override
    public List<RuleViolation> getCachedViolations(TextDocument sourceFile) {
        AnalysisResult analysisResult = (AnalysisResult)this.fileResultsCache.get(sourceFile.getFileId());
        if (analysisResult == null) {
            return Collections.emptyList();
        }
        return analysisResult.getViolations();
    }

    @Override
    public void analysisFailed(TextDocument sourceFile) {
        this.updatedResultsCache.remove(sourceFile.getFileId());
    }

    protected abstract boolean cacheExists();

    @Override
    public void checkValidity(RuleSets ruleSets, ClassLoader auxclassPathClassLoader, Collection<? extends TextFile> files) {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.ANALYSIS_CACHE, "validity check");){
            long currentAuxClassPathChecksum;
            boolean cacheIsValid = this.cacheExists();
            if (cacheIsValid && ruleSets.getChecksum() != this.rulesetChecksum) {
                LOG.debug("Analysis cache invalidated, rulesets changed.");
                cacheIsValid = false;
            }
            if (auxclassPathClassLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)auxclassPathClassLoader;
                currentAuxClassPathChecksum = FINGERPRINTER.fingerprint(urlClassLoader.getURLs());
                if (cacheIsValid && currentAuxClassPathChecksum != this.auxClassPathChecksum) {
                    LOG.debug("Analysis cache invalidated, auxclasspath changed.");
                    cacheIsValid = false;
                }
            } else {
                currentAuxClassPathChecksum = 0L;
            }
            long currentExecutionClassPathChecksum = FINGERPRINTER.fingerprint(this.getClassPathEntries());
            if (cacheIsValid && currentExecutionClassPathChecksum != this.executionClassPathChecksum) {
                LOG.debug("Analysis cache invalidated, execution classpath changed.");
                cacheIsValid = false;
            }
            if (!cacheIsValid) {
                this.fileResultsCache.clear();
            }
            this.rulesetChecksum = ruleSets.getChecksum();
            this.auxClassPathChecksum = currentAuxClassPathChecksum;
            this.executionClassPathChecksum = currentExecutionClassPathChecksum;
            this.ruleMapper.initialize(ruleSets);
        }
    }

    private static boolean isClassPathWildcard(String entry) {
        return entry.endsWith("/*") || entry.endsWith("\\*");
    }

    private URL[] getClassPathEntries() {
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        final ArrayList<URL> entries = new ArrayList<URL>();
        final SimpleFileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isSymbolicLink()) {
                    entries.add(file.toUri().toURL());
                }
                return FileVisitResult.CONTINUE;
            }
        };
        SimpleFileVisitor<Path> jarFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String extension = IOUtil.getFilenameExtension(file.toString());
                if ("jar".equalsIgnoreCase(extension)) {
                    fileVisitor.visitFile(file, attrs);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            for (String entry : classpathEntries) {
                File f = new File(entry);
                if (AbstractAnalysisCache.isClassPathWildcard(entry)) {
                    Files.walkFileTree(new File(entry.substring(0, entry.length() - 1)).toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, (FileVisitor<? super Path>)jarFileVisitor);
                    continue;
                }
                if (f.isFile()) {
                    entries.add(f.toURI().toURL());
                    continue;
                }
                if (!f.exists()) continue;
                Files.walkFileTree(f.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)fileVisitor);
            }
        }
        catch (IOException e) {
            LOG.error("Incremental analysis can't check execution classpath contents", (Throwable)e);
            throw new RuntimeException(e);
        }
        return entries.toArray(new URL[0]);
    }

    @Override
    public FileAnalysisListener startFileAnalysis(final TextDocument file) {
        final FileId fileName = file.getFileId();
        return new FileAnalysisListener(){
            private boolean failed = false;

            @Override
            public void onRuleViolation(RuleViolation violation) {
                if (!this.failed) {
                    ((AnalysisResult)AbstractAnalysisCache.this.updatedResultsCache.get(fileName)).addViolation(violation);
                }
            }

            @Override
            public void onError(Report.ProcessingError error) {
                this.failed = true;
                AbstractAnalysisCache.this.analysisFailed(file);
            }
        };
    }
}

