/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CSVWithLinecountPerFileRenderer;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.LoggerFactory;

public class CPDConfiguration
extends AbstractConfiguration {
    public static final String DEFAULT_LANGUAGE = "java";
    public static final String DEFAULT_RENDERER = "text";
    private static final Map<String, Class<? extends CPDReportRenderer>> RENDERERS = new HashMap<String, Class<? extends CPDReportRenderer>>();
    private int minimumTileSize;
    private boolean skipDuplicates;
    private String rendererName = "text";
    private @Nullable CPDReportRenderer cpdReportRenderer;
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;
    private boolean ignoreAnnotations;
    private boolean ignoreUsings;
    private boolean ignoreLiteralSequences = false;
    private boolean ignoreIdentifierAndLiteralSequences = false;
    private boolean skipLexicalErrors = false;
    private boolean noSkipBlocks = false;
    private String skipBlocksPattern = "#if 0|#endif";
    private boolean help;
    private boolean failOnViolation = true;

    public CPDConfiguration() {
        this(LanguageRegistry.CPD);
    }

    public CPDConfiguration(LanguageRegistry languageRegistry) {
        super(languageRegistry, new SimpleMessageReporter(LoggerFactory.getLogger(CpdAnalysis.class)));
    }

    @Override
    public void setSourceEncoding(Charset sourceEncoding) {
        super.setSourceEncoding(sourceEncoding);
        if (this.cpdReportRenderer != null) {
            CPDConfiguration.setRendererEncoding(this.cpdReportRenderer, sourceEncoding);
        }
    }

    static CPDReportRenderer createRendererByName(String name, Charset encoding) {
        CPDReportRenderer renderer;
        Class<CPDReportRenderer> rendererClass;
        if (name == null || "".equals(name)) {
            name = DEFAULT_RENDERER;
        }
        if ((rendererClass = RENDERERS.get(name.toLowerCase(Locale.ROOT))) == null) {
            try {
                Class<?> klass = Class.forName(name);
                if (!CPDReportRenderer.class.isAssignableFrom(klass)) {
                    throw new IllegalArgumentException("Class " + name + " does not implement " + CPDReportRenderer.class);
                }
                rendererClass = klass;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find class " + name);
            }
        }
        try {
            renderer = rendererClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            CPDConfiguration.setRendererEncoding(renderer, encoding);
        }
        catch (Exception e) {
            System.err.println("Couldn't instantiate renderer, defaulting to SimpleRenderer: " + e);
            renderer = new SimpleRenderer();
        }
        return renderer;
    }

    private static void setRendererEncoding(@NonNull Object renderer, Charset encoding) {
        try {
            PropertyDescriptor encodingProperty = new PropertyDescriptor("encoding", renderer.getClass());
            Method method = encodingProperty.getWriteMethod();
            if (method == null) {
                return;
            }
            if (method.getParameterTypes()[0] == Charset.class) {
                method.invoke(renderer, encoding);
            } else if (method.getParameterTypes()[0] == String.class) {
                method.invoke(renderer, encoding.name());
            }
        }
        catch (IntrospectionException | ReflectiveOperationException exception) {
            // empty catch block
        }
    }

    public static Set<String> getRenderers() {
        return Collections.unmodifiableSet(RENDERERS.keySet());
    }

    public int getMinimumTileSize() {
        return this.minimumTileSize;
    }

    public void setMinimumTileSize(int minimumTileSize) {
        this.minimumTileSize = minimumTileSize;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }

    public String getRendererName() {
        return this.rendererName;
    }

    public void setRendererName(String rendererName) {
        this.rendererName = rendererName;
        if (rendererName == null) {
            this.cpdReportRenderer = null;
        }
        this.cpdReportRenderer = CPDConfiguration.createRendererByName(rendererName, this.getSourceEncoding());
    }

    public CPDReportRenderer getCPDReportRenderer() {
        return this.cpdReportRenderer;
    }

    void setRenderer(CPDReportRenderer renderer) {
        this.cpdReportRenderer = renderer;
    }

    public boolean isIgnoreLiterals() {
        return this.ignoreLiterals;
    }

    public void setIgnoreLiterals(boolean ignoreLiterals) {
        this.ignoreLiterals = ignoreLiterals;
    }

    public boolean isIgnoreIdentifiers() {
        return this.ignoreIdentifiers;
    }

    public void setIgnoreIdentifiers(boolean ignoreIdentifiers) {
        this.ignoreIdentifiers = ignoreIdentifiers;
    }

    public boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public boolean isIgnoreUsings() {
        return this.ignoreUsings;
    }

    public void setIgnoreUsings(boolean ignoreUsings) {
        this.ignoreUsings = ignoreUsings;
    }

    public boolean isIgnoreLiteralSequences() {
        return this.ignoreLiteralSequences;
    }

    public void setIgnoreLiteralSequences(boolean ignoreLiteralSequences) {
        this.ignoreLiteralSequences = ignoreLiteralSequences;
    }

    public boolean isIgnoreIdentifierAndLiteralSequences() {
        return this.ignoreIdentifierAndLiteralSequences;
    }

    public void setIgnoreIdentifierAndLiteralSequences(boolean ignoreIdentifierAndLiteralSequences) {
        this.ignoreIdentifierAndLiteralSequences = ignoreIdentifierAndLiteralSequences;
    }

    public boolean isSkipLexicalErrors() {
        return this.skipLexicalErrors;
    }

    public void setSkipLexicalErrors(boolean skipLexicalErrors) {
        this.skipLexicalErrors = skipLexicalErrors;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isNoSkipBlocks() {
        return this.noSkipBlocks;
    }

    public void setNoSkipBlocks(boolean noSkipBlocks) {
        this.noSkipBlocks = noSkipBlocks;
    }

    public String getSkipBlocksPattern() {
        return this.skipBlocksPattern;
    }

    public void setSkipBlocksPattern(String skipBlocksPattern) {
        this.skipBlocksPattern = skipBlocksPattern;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    static {
        RENDERERS.put(DEFAULT_RENDERER, SimpleRenderer.class);
        RENDERERS.put("xml", XMLRenderer.class);
        RENDERERS.put("csv", CSVRenderer.class);
        RENDERERS.put("csv_with_linecount_per_file", CSVWithLinecountPerFileRenderer.class);
        RENDERERS.put("vs", VSRenderer.class);
    }
}

