/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.util.AssertionUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathClassLoader.class);
    String javaHome;
    private FileSystem fileSystem;
    private Map<String, Set<String>> packagesDirsToModules;

    public ClasspathClassLoader(List<File> files, ClassLoader parent) throws IOException {
        super(new URL[0], parent);
        for (URL url : this.fileToURL(files)) {
            this.addURL(url);
        }
    }

    public ClasspathClassLoader(String classpath, ClassLoader parent) throws IOException {
        super(new URL[0], parent);
        for (URL url : this.initURLs(classpath)) {
            this.addURL(url);
        }
    }

    private List<URL> fileToURL(List<File> files) throws IOException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (File f : files) {
            urlList.add(this.createURLFromPath(f.getAbsolutePath()));
        }
        return urlList;
    }

    private List<URL> initURLs(String classpath) {
        AssertionUtil.requireParamNotNull("classpath", classpath);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            if (classpath.startsWith("file:")) {
                this.addFileURLs(urls, new URL(classpath));
            } else {
                this.addClasspathURLs(urls, classpath);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot prepend classpath " + classpath + "\n" + e.getMessage(), e);
        }
        return urls;
    }

    private void addClasspathURLs(List<URL> urls, String classpath) throws MalformedURLException {
        StringTokenizer toker = new StringTokenizer(classpath, File.pathSeparator);
        while (toker.hasMoreTokens()) {
            String token = toker.nextToken();
            LOG.debug("Adding classpath entry: <{}>", (Object)token);
            urls.add(this.createURLFromPath(token));
        }
    }

    private void addFileURLs(List<URL> urls, URL fileURL) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                LOG.debug("Read classpath entry line: <{}>", (Object)line);
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                LOG.debug("Adding classpath entry: <{}>", (Object)line);
                urls.add(this.createURLFromPath(line));
            }
        }
    }

    private URL createURLFromPath(String path) throws MalformedURLException {
        Path filePath = Paths.get(path, new String[0]).toAbsolutePath();
        if (filePath.endsWith(Paths.get("lib", "jrt-fs.jar"))) {
            this.initializeJrtFilesystem(filePath);
            return null;
        }
        return filePath.toUri().normalize().toURL();
    }

    private void initializeJrtFilesystem(Path filePath) {
        try {
            LOG.debug("Detected Java Runtime Filesystem Provider in {}", (Object)filePath);
            if (this.fileSystem != null) {
                throw new IllegalStateException("There is already a jrt filesystem. Do you have multiple jrt-fs.jar files on the classpath?");
            }
            if (filePath.getNameCount() < 2) {
                throw new IllegalArgumentException("Can't determine java home from " + filePath + " - please provide a complete path.");
            }
            try (URLClassLoader loader = new URLClassLoader(new URL[]{filePath.toUri().toURL()});){
                HashMap<String, String> env = new HashMap<String, String>();
                this.javaHome = filePath.getParent().getParent().toString();
                env.put("java.home", this.javaHome);
                LOG.debug("Creating jrt-fs with env {}", env);
                this.fileSystem = FileSystems.newFileSystem(URI.create("jrt:/"), env, (ClassLoader)loader);
            }
            this.packagesDirsToModules = new HashMap<String, Set<String>>();
            Path packages = this.fileSystem.getPath("packages", new String[0]);
            try (Stream<Path> packagesStream = Files.list(packages);){
                packagesStream.forEach(p -> {
                    String packageName = p.getFileName().toString().replace('.', '/');
                    try (Stream<Path> modulesStream = Files.list(p);){
                        Set modules = modulesStream.map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
                        this.packagesDirsToModules.put(packageName, modules);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[[" + StringUtils.join((Object[])this.getURLs(), (String)":") + "] jrt-fs: " + this.javaHome + " parent: " + this.getParent() + ']';
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        int lastSlash;
        String packageName;
        Set<String> moduleNames;
        if (this.fileSystem != null && (moduleNames = this.packagesDirsToModules.get(packageName = name.substring(0, Math.max(lastSlash = name.lastIndexOf(47), 0)))) != null) {
            LOG.trace("Trying to find {} in jrt-fs with packageName={} and modules={}", new Object[]{name, packageName, moduleNames});
            for (String moduleCandidate : moduleNames) {
                Path candidate = this.fileSystem.getPath("modules", moduleCandidate, name);
                if (!Files.exists(candidate, new LinkOption[0])) continue;
                LOG.trace("Found {}", (Object)candidate);
                try {
                    return Files.newInputStream(candidate, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.findResource(name);
        if (url == null) {
            return super.getResource(name);
        }
        return url;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        throw new IllegalStateException("This class loader shouldn't be used to load classes");
    }

    @Override
    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.close();
            ClassLoader classLoader = this.fileSystem.getClass().getClassLoader();
            if (classLoader instanceof URLClassLoader) {
                ((URLClassLoader)classLoader).close();
            }
            this.packagesDirsToModules = null;
            this.fileSystem = null;
        }
        super.close();
    }

    static {
        ClasspathClassLoader.registerAsParallelCapable();
    }
}

