/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageRegistry
implements Iterable<Language> {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageRegistry.class);
    private static final LanguageRegistry ALL_LANGUAGES = LanguageRegistry.loadLanguages(LanguageRegistry.class.getClassLoader());
    public static final LanguageRegistry PMD = ALL_LANGUAGES.filter(it -> it instanceof PmdCapableLanguage);
    public static final LanguageRegistry CPD = ALL_LANGUAGES.filter(it -> it instanceof CpdCapableLanguage);
    private final Set<Language> languages;
    private final Map<String, Language> languagesById;
    private final Map<String, Language> languagesByFullName;

    public LanguageRegistry(Set<? extends Language> languages) {
        this.languages = languages.stream().sorted(Comparator.comparing(Language::getId, String::compareToIgnoreCase)).collect(CollectionUtil.toUnmodifiableSet());
        this.languagesById = CollectionUtil.associateBy(languages, Language::getId);
        this.languagesByFullName = CollectionUtil.associateBy(languages, Language::getName);
    }

    public LanguageRegistry filter(Predicate<Language> filterFun) {
        return new LanguageRegistry(this.languages.stream().filter(filterFun).collect(Collectors.toSet()));
    }

    public static LanguageRegistry singleton(Language l) {
        return new LanguageRegistry(Collections.singleton(l));
    }

    public LanguageRegistry getDependenciesOf(Language lang) {
        HashSet<Language> result = new HashSet<Language>();
        result.add(lang);
        this.addDepsOrThrow(lang, result);
        return new LanguageRegistry(result);
    }

    private void addDepsOrThrow(Language l, Set<Language> languages) {
        for (String depId : l.getDependencies()) {
            Language dep = this.getLanguageById(depId);
            if (dep == null) {
                throw new IllegalStateException("Cannot find language " + depId + " in " + this);
            }
            if (!languages.add(dep)) continue;
            this.addDepsOrThrow(dep, languages);
        }
    }

    @Override
    public @NonNull Iterator<Language> iterator() {
        return this.languages.iterator();
    }

    public static @NonNull LanguageRegistry loadLanguages(ClassLoader classLoader) {
        TreeSet<Language> languages = new TreeSet<Language>(Comparator.comparing(Language::getId, String::compareToIgnoreCase));
        ServiceLoader<Language> languageLoader = ServiceLoader.load(Language.class, classLoader);
        Iterator<Language> iterator = languageLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    Language language = iterator.next();
                    languages.add(language);
                }
            }
            catch (UnsupportedClassVersionError | ServiceConfigurationError e) {
                LOG.warn("Cannot load PMD language, ignored", (Throwable)e);
                continue;
            }
            break;
        }
        return new LanguageRegistry(languages);
    }

    public Set<Language> getLanguages() {
        return this.languages;
    }

    public @Nullable Language getLanguageById(@Nullable String langId) {
        return this.languagesById.get(langId);
    }

    public @Nullable LanguageVersion getLanguageVersionById(@Nullable String langId, @Nullable String version) {
        Language lang = this.languagesById.get(langId);
        if (lang == null) {
            return null;
        }
        return version == null ? lang.getDefaultVersion() : lang.getVersion(version);
    }

    public @Nullable Language getLanguageByFullName(String languageName) {
        return this.languagesByFullName.get(languageName);
    }

    public @NonNull String commaSeparatedList(Function<? super Language, String> languageToString) {
        return this.getLanguages().stream().map(languageToString).sorted().collect(Collectors.joining(", "));
    }

    public String toString() {
        return "LanguageRegistry(" + this.commaSeparatedList(Language::getId) + ")";
    }
}

