/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.NoAttribute;
import net.sourceforge.pmd.lang.rule.xpath.impl.AttributeAxisIterator;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.util.DataMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Node
extends Reportable {
    public static final Comparator<Node> COORDS_COMPARATOR = Comparator.comparing(Node::getReportLocation, FileLocation.COMPARATOR);

    default public String getImage() {
        return null;
    }

    default public boolean hasImageEqualTo(String image) {
        return Objects.equals(this.getImage(), image);
    }

    default public int compareLocation(Node other) {
        return COORDS_COMPARATOR.compare(this, other);
    }

    @Override
    default public FileLocation getReportLocation() {
        return this.getAstInfo().getTextDocument().toLocation(this.getTextRegion());
    }

    public TextRegion getTextRegion();

    default public int getBeginLine() {
        return this.getReportLocation().getStartLine();
    }

    default public int getBeginColumn() {
        return this.getReportLocation().getStartColumn();
    }

    default public int getEndLine() {
        return this.getReportLocation().getEndLine();
    }

    default public int getEndColumn() {
        return this.getReportLocation().getEndColumn();
    }

    @NoAttribute
    default public boolean isFindBoundary() {
        return false;
    }

    public DataMap<DataMap.DataKey<?, ?>> getUserMap();

    default public @NonNull TextDocument getTextDocument() {
        return this.getAstInfo().getTextDocument();
    }

    public Node getParent();

    public Node getChild(int var1);

    public int getNumChildren();

    public int getIndexInParent();

    default public <P, R> R acceptVisitor(AstVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.cannotVisit(this, data);
    }

    default public AstInfo<? extends RootNode> getAstInfo() {
        return this.getRoot().getAstInfo();
    }

    public String getXPathNodeName();

    default public Iterator<Attribute> getXPathAttributesIterator() {
        return new AttributeAxisIterator(this);
    }

    default public @Nullable Node getFirstChild() {
        return this.getNumChildren() > 0 ? this.getChild(0) : null;
    }

    default public @Nullable Node getLastChild() {
        return this.getNumChildren() > 0 ? this.getChild(this.getNumChildren() - 1) : null;
    }

    default public @Nullable Node getPreviousSibling() {
        Node parent = this.getParent();
        int idx = this.getIndexInParent();
        if (parent != null && idx > 0) {
            return parent.getChild(idx - 1);
        }
        return null;
    }

    default public @Nullable Node getNextSibling() {
        Node parent = this.getParent();
        int idx = this.getIndexInParent();
        if (parent != null && idx + 1 < parent.getNumChildren()) {
            return parent.getChild(idx + 1);
        }
        return null;
    }

    default public NodeStream<? extends Node> asStream() {
        return StreamImpl.singleton(this);
    }

    default public NodeStream<? extends Node> children() {
        return StreamImpl.children(this);
    }

    default public NodeStream.DescendantNodeStream<? extends Node> descendants() {
        return StreamImpl.descendants(this);
    }

    default public NodeStream.DescendantNodeStream<? extends Node> descendantsOrSelf() {
        return StreamImpl.descendantsOrSelf(this);
    }

    default public NodeStream<? extends Node> ancestors() {
        return StreamImpl.ancestors(this);
    }

    default public NodeStream<? extends Node> ancestorsOrSelf() {
        return StreamImpl.ancestorsOrSelf(this);
    }

    default public <R extends Node> NodeStream<R> children(Class<? extends R> rClass) {
        return StreamImpl.children(this, rClass);
    }

    default public <R extends Node> @Nullable R firstChild(Class<? extends R> rClass) {
        return this.children(rClass).first();
    }

    default public <R extends Node> NodeStream.DescendantNodeStream<R> descendants(Class<? extends R> rClass) {
        return StreamImpl.descendants(this, rClass);
    }

    default public <R extends Node> NodeStream<R> ancestors(Class<? extends R> rClass) {
        return StreamImpl.ancestors(this, rClass);
    }

    default public @NonNull RootNode getRoot() {
        Node r = this;
        while (r.getParent() != null) {
            r = r.getParent();
        }
        if (!(r instanceof RootNode)) {
            throw new AssertionError((Object)"Root of the tree should implement RootNode");
        }
        return (RootNode)r;
    }

    default public LanguageVersion getLanguageVersion() {
        return this.getTextDocument().getLanguageVersion();
    }
}

