/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast;

import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ParseException
extends FileAnalysisException {
    private @Nullable FileLocation location;

    public ParseException(String message) {
        super(message);
        this.location = null;
    }

    public ParseException(Throwable cause) {
        super(cause);
        this.location = null;
    }

    public ParseException(@NonNull JavaccToken currentTokenVal, int[][] expectedTokenSequencesVal) {
        super(ParseException.makeMessage(currentTokenVal, expectedTokenSequencesVal));
        this.location = currentTokenVal.getNext().getReportLocation();
    }

    public ParseException withLocation(FileLocation loc) {
        this.location = loc;
        super.setFileId(loc.getFileId());
        return this;
    }

    public ParseException withLocation(Reportable reportable) {
        return this.withLocation(reportable.getReportLocation());
    }

    @Override
    protected String errorKind() {
        return "Parse exception";
    }

    @Override
    protected @Nullable FileLocation location() {
        return this.location;
    }

    private static String makeMessage(@NonNull JavaccToken currentToken, int[][] expectedTokenSequences) {
        JavaccTokenDocument document = currentToken.getDocument();
        String eol = System.lineSeparator();
        LinkedHashSet<String> expectedBranches = new LinkedHashSet<String>();
        int maxSize = 0;
        for (int[] expectedTokenSequence : expectedTokenSequences) {
            StringBuilder expected = new StringBuilder();
            if (maxSize < expectedTokenSequence.length) {
                maxSize = expectedTokenSequence.length;
            }
            for (int i : expectedTokenSequence) {
                expected.append(document.describeKind(i)).append(' ');
            }
            if (expectedTokenSequence[expectedTokenSequence.length - 1] != 0) {
                expected.append("...");
            }
            expectedBranches.add(expected.toString());
        }
        String expected = expectedBranches.stream().collect(Collectors.joining(System.lineSeparator() + "    "));
        StringBuilder retval = new StringBuilder("Encountered ");
        if (maxSize > 1) {
            retval.append('[');
        }
        JavaccToken tok = currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval.append(' ');
            }
            if (tok.kind == 0) {
                retval.append(document.describeKind(0));
                break;
            }
            String kindStr = document.describeKind(tok.kind);
            String image = StringUtil.escapeJava(tok.getImage());
            retval.append(kindStr);
            if (!ParseException.isEnquotedVersion(kindStr, image)) {
                retval.deleteCharAt(retval.length() - 1);
                retval.append(": \"");
                retval.append(image);
                retval.append("\">");
            }
            tok = tok.next;
        }
        if (maxSize > 1) {
            retval.append(']');
        }
        retval.append('.').append(eol);
        if (expectedTokenSequences.length == 1) {
            retval.append("Was expecting:").append(eol).append("    ");
        } else {
            retval.append("Was expecting one of:").append(eol).append("    ");
        }
        retval.append(expected);
        return retval.toString();
    }

    private static boolean isEnquotedVersion(String kindStr, String image) {
        return kindStr.equals('\"' + image + '\"');
    }
}

