/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.sourceforge.pmd.internal.util.BaseCloseable;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.ReadOnlyFileException;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextFileContent;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class NioTextFile
extends BaseCloseable
implements TextFile {
    private final Path path;
    private final Charset charset;
    private final LanguageVersion languageVersion;
    private final FileId fileId;
    private boolean readOnly;

    NioTextFile(Path path, @Nullable FileId parentFsPath, Charset charset, LanguageVersion languageVersion, boolean readOnly) {
        AssertionUtil.requireParamNotNull("path", path);
        AssertionUtil.requireParamNotNull("charset", charset);
        AssertionUtil.requireParamNotNull("language version", languageVersion);
        this.readOnly = readOnly;
        this.path = path;
        this.charset = charset;
        this.languageVersion = languageVersion;
        this.fileId = FileId.fromPath(path, parentFsPath);
    }

    @Override
    public @NonNull LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public FileId getFileId() {
        return this.fileId;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly || !Files.isWritable(this.path);
    }

    @Override
    public void writeContents(TextFileContent content) throws IOException {
        this.ensureOpen();
        if (this.isReadOnly()) {
            throw new ReadOnlyFileException(this);
        }
        try (BufferedWriter bw = Files.newBufferedWriter(this.path, this.charset, new OpenOption[0]);){
            if ("\n".equals(content.getLineTerminator())) {
                content.getNormalizedText().writeFully(bw);
            } else {
                for (Chars line : content.getNormalizedText().lines()) {
                    line.writeFully(bw);
                    bw.write(content.getLineTerminator());
                }
            }
        }
    }

    @Override
    public TextFileContent readContents() throws IOException {
        this.ensureOpen();
        if (!Files.isRegularFile(this.path, new LinkOption[0])) {
            throw new IOException("Not a regular file: " + this.path);
        }
        return TextFileContent.fromInputStream(Files.newInputStream(this.path, new OpenOption[0]), this.charset);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NioTextFile that = (NioTextFile)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "NioTextFile[charset=" + this.charset + ", path=" + this.path + ']';
    }
}

