/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.document.TextFileContent;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

class StringTextFile
implements TextFile {
    private final TextFileContent content;
    private final FileId fileId;
    private final LanguageVersion languageVersion;

    StringTextFile(CharSequence source, FileId fileId, LanguageVersion languageVersion) {
        AssertionUtil.requireParamNotNull("source text", source);
        AssertionUtil.requireParamNotNull("file name", fileId);
        AssertionUtil.requireParamNotNull("language version", languageVersion);
        this.languageVersion = languageVersion;
        this.content = TextFileContent.fromCharSeq(source);
        this.fileId = fileId;
    }

    @Override
    public @NonNull LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public FileId getFileId() {
        return this.fileId;
    }

    @Override
    public TextFileContent readContents() {
        return this.content;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "ReadOnlyString[" + StringUtil.elide(this.content.getNormalizedText().toString(), 40, "...") + "]";
    }
}

