/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.impl;

import java.util.ArrayList;
import net.sourceforge.pmd.lang.InternalApiBridge;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.impl.AbstractPMDProcessor;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class BatchLanguageProcessor<P extends LanguagePropertyBundle>
implements LanguageProcessor {
    private final PmdCapableLanguage language;
    private final P bundle;
    private final LanguageVersion version;

    protected BatchLanguageProcessor(P bundle) {
        if (!(((LanguagePropertyBundle)bundle).getLanguage() instanceof PmdCapableLanguage)) {
            throw new IllegalArgumentException("Cannot create a processor for a language which does not support PMD: " + ((LanguagePropertyBundle)bundle).getLanguage());
        }
        this.language = (PmdCapableLanguage)((LanguagePropertyBundle)bundle).getLanguage();
        this.bundle = bundle;
        this.version = ((LanguagePropertyBundle)bundle).getLanguageVersion();
    }

    public P getProperties() {
        return this.bundle;
    }

    @Override
    public @NonNull LanguageVersion getLanguageVersion() {
        return this.version;
    }

    @Override
    public final @NonNull PmdCapableLanguage getLanguage() {
        return this.language;
    }

    @Override
    public @NonNull AutoCloseable launchAnalysis(@NonNull LanguageProcessor.AnalysisTask task) {
        ArrayList<TextFile> files = new ArrayList<TextFile>(task.getFiles());
        files.removeIf(it -> !it.getLanguageVersion().getLanguage().equals(this.getLanguage()));
        LanguageProcessor.AnalysisTask newTask = InternalApiBridge.taskWithFiles(task, files);
        task.getRulesets().initializeRules(task.getLpRegistry(), task.getMessageReporter());
        AbstractPMDProcessor processor = AbstractPMDProcessor.newFileProcessor(newTask);
        processor.processFiles();
        return processor;
    }

    @Override
    public void close() throws Exception {
    }
}

