/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReference;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.StringUtil;

public class RuleReference
implements Rule {
    private Rule rule;
    private LanguageVersion minimumLanguageVersion;
    private LanguageVersion maximumLanguageVersion;
    private Boolean deprecated;
    private String name;
    private List<PropertyDescriptor<?>> propertyDescriptors;
    private Map<PropertyDescriptor<?>, Object> propertyValues;
    private String message;
    private String description;
    private List<String> examples;
    private String externalInfoUrl;
    private RulePriority priority;
    private RuleSetReference ruleSetReference;

    public RuleReference(Rule theRule, RuleSetReference theRuleSetReference) {
        this.rule = theRule;
        this.ruleSetReference = theRuleSetReference;
    }

    private RuleReference(RuleReference ref) {
        this.rule = ref.rule.deepCopy();
        this.minimumLanguageVersion = ref.minimumLanguageVersion;
        this.maximumLanguageVersion = ref.maximumLanguageVersion;
        this.deprecated = ref.deprecated;
        this.name = ref.name;
        this.propertyDescriptors = ref.propertyDescriptors;
        this.propertyValues = ref.propertyValues == null ? null : new HashMap(ref.propertyValues);
        this.message = ref.message;
        this.description = ref.description;
        this.examples = ref.examples == null ? null : new ArrayList<String>(ref.examples);
        this.externalInfoUrl = ref.externalInfoUrl;
        this.priority = ref.priority;
        this.ruleSetReference = ref.ruleSetReference;
    }

    public Rule getRule() {
        return this.rule;
    }

    public LanguageVersion getOverriddenMinimumLanguageVersion() {
        return this.minimumLanguageVersion;
    }

    @Override
    public void setMinimumLanguageVersion(LanguageVersion minimumLanguageVersion) {
        if (!Objects.equals(minimumLanguageVersion, this.rule.getMinimumLanguageVersion()) || this.minimumLanguageVersion != null) {
            this.rule.setMinimumLanguageVersion(minimumLanguageVersion);
            this.minimumLanguageVersion = minimumLanguageVersion;
        }
    }

    public LanguageVersion getOverriddenMaximumLanguageVersion() {
        return this.maximumLanguageVersion;
    }

    @Override
    public void setMaximumLanguageVersion(LanguageVersion maximumLanguageVersion) {
        if (!Objects.equals(maximumLanguageVersion, this.rule.getMaximumLanguageVersion()) || this.maximumLanguageVersion != null) {
            this.rule.setMaximumLanguageVersion(maximumLanguageVersion);
            this.maximumLanguageVersion = maximumLanguageVersion;
        }
    }

    public Boolean isOverriddenDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated != false;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated ? Boolean.valueOf(deprecated) : null;
    }

    public String getOverriddenName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.rule.getName();
    }

    @Override
    public void setName(String name) {
        if (!RuleReference.isSame(name, this.rule.getName()) || this.name != null) {
            this.name = name;
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.rule.getName();
    }

    public String getOverriddenMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        if (!RuleReference.isSame(message, this.rule.getMessage()) || this.message != null) {
            this.message = message;
            this.rule.setMessage(message);
        }
    }

    public String getOverriddenDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (!RuleReference.isSame(description, this.rule.getDescription()) || this.description != null) {
            this.description = description;
            this.rule.setDescription(description);
        }
    }

    public List<String> getOverriddenExamples() {
        return this.examples;
    }

    @Override
    public void addExample(String example) {
        if (!RuleReference.contains(this.rule.getExamples(), example)) {
            if (this.examples == null) {
                this.examples = new ArrayList<String>(1);
            }
            this.examples.clear();
            this.examples.add(example);
            this.rule.addExample(example);
        }
    }

    public String getOverriddenExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String externalInfoUrl) {
        if (!RuleReference.isSame(externalInfoUrl, this.rule.getExternalInfoUrl()) || this.externalInfoUrl != null) {
            this.externalInfoUrl = externalInfoUrl;
            this.rule.setExternalInfoUrl(externalInfoUrl);
        }
    }

    public RulePriority getOverriddenPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(RulePriority priority) {
        if (priority != this.rule.getPriority() || this.priority != null) {
            this.priority = priority;
            this.rule.setPriority(priority);
        }
    }

    @Override
    public List<PropertyDescriptor<?>> getOverriddenPropertyDescriptors() {
        return this.propertyDescriptors == null ? Collections.emptyList() : new ArrayList(this.propertyDescriptors);
    }

    @Override
    public void definePropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) throws IllegalArgumentException {
        this.rule.definePropertyDescriptor(propertyDescriptor);
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new ArrayList();
        }
        this.propertyDescriptors.add(propertyDescriptor);
    }

    @Override
    public Map<PropertyDescriptor<?>, Object> getOverriddenPropertiesByPropertyDescriptor() {
        return this.propertyValues == null ? new HashMap() : new HashMap(this.propertyValues);
    }

    @Override
    public <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T value) {
        if (!Objects.equals(this.rule.getProperty(propertyDescriptor), value)) {
            if (this.propertyValues == null) {
                this.propertyValues = new HashMap();
            }
            this.propertyValues.put(propertyDescriptor, value);
            this.rule.setProperty(propertyDescriptor, value);
        }
    }

    public RuleSetReference getRuleSetReference() {
        return this.ruleSetReference;
    }

    private static boolean isSame(String s1, String s2) {
        return StringUtil.isSame(s1, s2, true, false, true);
    }

    private static boolean contains(Collection<String> collection, String s1) {
        for (String s2 : collection) {
            if (!RuleReference.isSame(s1, s2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasDescriptor(PropertyDescriptor<?> descriptor) {
        return this.propertyDescriptors != null && this.propertyDescriptors.contains(descriptor) || this.rule.hasDescriptor(descriptor);
    }

    @Override
    public boolean isPropertyOverridden(PropertyDescriptor<?> descriptor) {
        return this.propertyValues != null && this.propertyValues.containsKey(descriptor);
    }

    @Override
    public Rule deepCopy() {
        return new RuleReference(this);
    }

    public boolean hasOverriddenAttributes() {
        return this.deprecated != null || this.description != null || this.examples != null || this.externalInfoUrl != null || this.maximumLanguageVersion != null || this.minimumLanguageVersion != null || this.message != null || this.name != null || this.priority != null || this.propertyDescriptors != null || this.propertyValues != null;
    }

    @Override
    public Language getLanguage() {
        return this.rule.getLanguage();
    }

    @Override
    public void setLanguage(Language language) {
        this.rule.setLanguage(language);
    }

    @Override
    public LanguageVersion getMinimumLanguageVersion() {
        return this.rule.getMinimumLanguageVersion();
    }

    @Override
    public LanguageVersion getMaximumLanguageVersion() {
        return this.rule.getMaximumLanguageVersion();
    }

    @Override
    public String getSince() {
        return this.rule.getSince();
    }

    @Override
    public void setSince(String since) {
        this.rule.setSince(since);
    }

    @Override
    public String getRuleClass() {
        return this.rule.getRuleClass();
    }

    @Override
    public void setRuleClass(String ruleClass) {
        this.rule.setRuleClass(ruleClass);
    }

    @Override
    public String getRuleSetName() {
        return this.rule.getRuleSetName();
    }

    @Override
    public void setRuleSetName(String name) {
        this.rule.setRuleSetName(name);
    }

    @Override
    public String getMessage() {
        return this.rule.getMessage();
    }

    @Override
    public String getDescription() {
        return this.rule.getDescription();
    }

    @Override
    public List<String> getExamples() {
        return this.rule.getExamples();
    }

    @Override
    public String getExternalInfoUrl() {
        return this.rule.getExternalInfoUrl();
    }

    @Override
    public RulePriority getPriority() {
        return this.rule.getPriority();
    }

    @Override
    public RuleTargetSelector getTargetSelector() {
        return this.rule.getTargetSelector();
    }

    @Override
    public void initialize(LanguageProcessor languageProcessor) {
        this.rule.initialize(languageProcessor);
    }

    @Override
    public void start(RuleContext ctx) {
        this.rule.start(ctx);
    }

    @Override
    public void apply(Node target, RuleContext ctx) {
        this.rule.apply(target, ctx);
    }

    @Override
    public void end(RuleContext ctx) {
        this.rule.end(ctx);
    }

    @Override
    public PropertyDescriptor<?> getPropertyDescriptor(String name) {
        return this.rule.getPropertyDescriptor(name);
    }

    @Override
    public List<PropertyDescriptor<?>> getPropertyDescriptors() {
        return this.rule.getPropertyDescriptors();
    }

    @Override
    public <T> T getProperty(PropertyDescriptor<T> propertyDescriptor) {
        return this.rule.getProperty(propertyDescriptor);
    }

    @Override
    public Map<PropertyDescriptor<?>, Object> getPropertiesByPropertyDescriptor() {
        return this.rule.getPropertiesByPropertyDescriptor();
    }

    @Override
    public String dysfunctionReason() {
        return this.rule.dysfunctionReason();
    }
}

