/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.sourceforge.pmd.cache.internal.ChecksumAware;
import net.sourceforge.pmd.internal.util.PredicateUtil;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReference;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleSet
implements ChecksumAware {
    private static final Logger LOG = LoggerFactory.getLogger(RuleSet.class);
    private static final String MISSING_RULE = "Missing rule";
    private static final String MISSING_RULESET_DESCRIPTION = "RuleSet description must not be null";
    private static final String MISSING_RULESET_NAME = "RuleSet name must not be null";
    private final long checksum;
    private final List<Rule> rules;
    private final String fileName;
    private final String name;
    private final String description;
    private final List<Pattern> excludePatterns;
    private final List<Pattern> includePatterns;
    private final Predicate<String> filter;

    private RuleSet(RuleSetBuilder builder) {
        this.checksum = builder.checksum;
        this.fileName = builder.fileName;
        this.name = Objects.requireNonNull(builder.name, MISSING_RULESET_NAME);
        this.description = Objects.requireNonNull(builder.description, MISSING_RULESET_DESCRIPTION);
        this.rules = builder.rules;
        this.excludePatterns = Collections.unmodifiableList(new ArrayList(builder.excludePatterns));
        this.includePatterns = Collections.unmodifiableList(new ArrayList(builder.includePatterns));
        Predicate<String> regexFilter = PredicateUtil.buildRegexFilterIncludeOverExclude(this.includePatterns, this.excludePatterns);
        this.filter = PredicateUtil.toNormalizedFileFilter(regexFilter);
    }

    public RuleSet(RuleSet rs) {
        this.checksum = rs.checksum;
        this.fileName = rs.fileName;
        this.name = rs.name;
        this.description = rs.description;
        this.rules = new ArrayList<Rule>(rs.rules.size());
        for (Rule rule : rs.rules) {
            this.rules.add(rule.deepCopy());
        }
        this.excludePatterns = rs.excludePatterns;
        this.includePatterns = rs.includePatterns;
        this.filter = rs.filter;
    }

    public static RuleSet forSingleRule(Rule rule) {
        long checksum = rule instanceof XPathRule ? (long)((XPathRule)rule).getXPathExpression().hashCode() : (long)(rule.getPropertiesByPropertyDescriptor().values().hashCode() * 31 + rule.getName().hashCode());
        RuleSetBuilder builder = new RuleSetBuilder(checksum).withName(rule.getName()).withDescription("RuleSet for " + rule.getName());
        builder.addRule(rule);
        return builder.build();
    }

    public static RuleSet create(String name, String description, String fileName, Collection<Pattern> excludePatterns, Collection<Pattern> includePatterns, Iterable<? extends Rule> rules) {
        RuleSetBuilder builder = new RuleSetBuilder(0L);
        builder.withName(name).withDescription(description).withFileName(fileName).replaceFileExclusions(excludePatterns).replaceFileInclusions(includePatterns);
        for (Rule rule : rules) {
            builder.addRule(rule);
        }
        return builder.build();
    }

    public static RuleSet copy(RuleSet original) {
        return new RuleSet(original);
    }

    public int size() {
        return this.rules.size();
    }

    public Collection<Rule> getRules() {
        return this.rules;
    }

    public Rule getRuleByName(String ruleName) {
        for (Rule r : this.rules) {
            if (!r.getName().equals(ruleName)) continue;
            return r;
        }
        return null;
    }

    boolean applies(FileId qualFileName) {
        return this.filter.test(qualFileName.getAbsolutePath());
    }

    static boolean applies(Rule rule, LanguageVersion languageVersion) {
        LanguageVersion min = rule.getMinimumLanguageVersion();
        LanguageVersion max = rule.getMaximumLanguageVersion();
        assert (rule.getLanguage() != null) : "Rule has no language " + rule;
        return !(!rule.getLanguage().equals(languageVersion.getLanguage()) || min != null && min.compareTo(languageVersion) > 0 || max != null && max.compareTo(languageVersion) < 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RuleSet)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RuleSet ruleSet = (RuleSet)o;
        return this.getName().equals(ruleSet.getName()) && this.getRules().equals(ruleSet.getRules());
    }

    public int hashCode() {
        return this.getName().hashCode() + 13 * this.getRules().hashCode();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Pattern> getFileExclusions() {
        return this.excludePatterns;
    }

    public List<Pattern> getFileInclusions() {
        return this.includePatterns;
    }

    public void removeDysfunctionalRules(Collection<Rule> collector) {
        Iterator<Rule> iter = this.rules.iterator();
        while (iter.hasNext()) {
            Rule rule = iter.next();
            if (rule.dysfunctionReason() == null) continue;
            iter.remove();
            collector.add(rule);
        }
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    static class RuleSetBuilder {
        public String description;
        public String name;
        public String fileName;
        private final List<Rule> rules = new ArrayList<Rule>();
        private final Set<Pattern> excludePatterns = new LinkedHashSet<Pattern>();
        private final Set<Pattern> includePatterns = new LinkedHashSet<Pattern>();
        private final long checksum;

        RuleSetBuilder(long checksum) {
            this.checksum = checksum;
        }

        RuleSetBuilder(RuleSet original) {
            this.checksum = original.getChecksum();
            this.withName(original.getName()).withDescription(original.getDescription()).withFileName(original.getFileName()).replaceFileExclusions(original.getFileExclusions()).replaceFileInclusions(original.getFileInclusions());
            this.addRuleSet(original);
        }

        public RuleSetBuilder addRule(Rule newRule) {
            if (newRule == null) {
                throw new IllegalArgumentException(RuleSet.MISSING_RULE);
            }
            for (Rule rule : this.rules) {
                if (!rule.getName().equals(newRule.getName()) || !rule.getLanguage().equals(newRule.getLanguage())) continue;
                LOG.warn("The rule with name {} is duplicated. Future versions of PMD will reject to load such rulesets.", (Object)newRule.getName());
                break;
            }
            this.rules.add(newRule);
            return this;
        }

        Rule getExistingRule(Rule rule) {
            for (Rule r : this.rules) {
                if (!r.getName().equals(rule.getName()) || !r.getLanguage().equals(rule.getLanguage())) continue;
                return r;
            }
            return null;
        }

        boolean hasRule(Rule rule) {
            return this.getExistingRule(rule) != null;
        }

        public RuleSetBuilder addRuleReplaceIfExists(Rule rule) {
            if (rule == null) {
                throw new IllegalArgumentException(RuleSet.MISSING_RULE);
            }
            Iterator<Rule> it = this.rules.iterator();
            while (it.hasNext()) {
                Rule r = it.next();
                if (!r.getName().equals(rule.getName()) || !r.getLanguage().equals(rule.getLanguage())) continue;
                it.remove();
            }
            this.addRule(rule);
            return this;
        }

        public RuleSetBuilder addRuleIfNotExists(Rule ruleOrRef) {
            if (ruleOrRef == null) {
                throw new IllegalArgumentException(RuleSet.MISSING_RULE);
            }
            Rule rule = ruleOrRef;
            while (rule instanceof RuleReference) {
                rule = ((RuleReference)rule).getRule();
            }
            boolean exists = this.hasRule(rule);
            if (!exists) {
                this.addRule(ruleOrRef);
            }
            return this;
        }

        public RuleSetBuilder addRuleByReference(String ruleSetFileName, Rule rule) {
            RuleReference ruleReference;
            if (StringUtils.isBlank((CharSequence)ruleSetFileName)) {
                throw new RuntimeException("Adding a rule by reference is not allowed with an empty rule set file name.");
            }
            if (rule == null) {
                throw new IllegalArgumentException("Cannot add a null rule reference to a RuleSet");
            }
            if (rule instanceof RuleReference) {
                ruleReference = (RuleReference)rule;
            } else {
                RuleSetReference ruleSetReference = new RuleSetReference(ruleSetFileName);
                ruleReference = new RuleReference(rule, ruleSetReference);
            }
            this.rules.add(ruleReference);
            return this;
        }

        public RuleSetBuilder addRuleSet(RuleSet ruleSet) {
            this.rules.addAll(ruleSet.getRules());
            return this;
        }

        public RuleSetBuilder addRuleSetByReference(RuleSet ruleSet, boolean allRules) {
            return this.addRuleSetByReference(ruleSet, allRules, null);
        }

        public RuleSetBuilder addRuleSetByReference(RuleSet ruleSet, boolean allRules, String ... excludes) {
            if (StringUtils.isBlank((CharSequence)ruleSet.getFileName())) {
                throw new RuntimeException("Adding a rule by reference is not allowed with an empty rule set file name.");
            }
            RuleSetReference ruleSetReference = excludes == null ? new RuleSetReference(ruleSet.getFileName(), allRules) : new RuleSetReference(ruleSet.getFileName(), allRules, new LinkedHashSet<String>(Arrays.asList(excludes)));
            for (Rule rule : ruleSet.getRules()) {
                RuleReference ruleReference = new RuleReference(rule, ruleSetReference);
                this.rules.add(ruleReference);
            }
            return this;
        }

        public RuleSetBuilder withFileExclusions(Pattern p1, Pattern ... rest) {
            Objects.requireNonNull(p1, "Pattern was null");
            Objects.requireNonNull(rest, "Other patterns was null");
            this.excludePatterns.add(p1);
            for (Pattern p : rest) {
                Objects.requireNonNull(p, "Pattern was null");
                this.excludePatterns.add(p);
            }
            return this;
        }

        public RuleSetBuilder withFileExclusions(Collection<? extends Pattern> patterns) {
            Objects.requireNonNull(patterns, "Pattern collection was null");
            for (Pattern pattern : patterns) {
                Objects.requireNonNull(pattern, "Pattern was null");
                this.excludePatterns.add(pattern);
            }
            return this;
        }

        public RuleSetBuilder replaceFileExclusions(Collection<? extends Pattern> patterns) {
            Objects.requireNonNull(patterns, "Pattern collection was null");
            this.excludePatterns.clear();
            for (Pattern pattern : patterns) {
                Objects.requireNonNull(pattern, "Pattern was null");
                this.excludePatterns.add(pattern);
            }
            return this;
        }

        public RuleSetBuilder withFileInclusions(Pattern p1, Pattern ... rest) {
            Objects.requireNonNull(p1, "Pattern was null");
            Objects.requireNonNull(rest, "Other patterns was null");
            this.includePatterns.add(p1);
            for (Pattern p : rest) {
                Objects.requireNonNull(p, "Pattern was null");
                this.includePatterns.add(p);
            }
            return this;
        }

        public RuleSetBuilder withFileInclusions(Collection<? extends Pattern> patterns) {
            Objects.requireNonNull(patterns, "Pattern collection was null");
            for (Pattern pattern : patterns) {
                Objects.requireNonNull(pattern, "Pattern was null");
                this.includePatterns.add(pattern);
            }
            return this;
        }

        public RuleSetBuilder replaceFileInclusions(Collection<? extends Pattern> patterns) {
            Objects.requireNonNull(patterns, "Pattern collection was null");
            this.includePatterns.clear();
            for (Pattern pattern : patterns) {
                Objects.requireNonNull(pattern, "Pattern was null");
                this.includePatterns.add(pattern);
            }
            return this;
        }

        public RuleSetBuilder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public RuleSetBuilder withName(String name) {
            this.name = Objects.requireNonNull(name, RuleSet.MISSING_RULESET_NAME);
            return this;
        }

        public RuleSetBuilder withDescription(String description) {
            this.description = Objects.requireNonNull(description, RuleSet.MISSING_RULESET_DESCRIPTION);
            return this;
        }

        public boolean hasDescription() {
            return this.description != null;
        }

        public String getName() {
            return this.name;
        }

        public RuleSet build() {
            return new RuleSet(this);
        }

        public void filterRulesByPriority(RulePriority minimumPriority) {
            Iterator<Rule> iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                Rule rule = iterator.next();
                if (rule.getPriority().compareTo(minimumPriority) <= 0) continue;
                LOG.debug("Removing rule {} due to priority: {} required: {}", new Object[]{rule.getName(), rule.getPriority(), minimumPriority});
                iterator.remove();
            }
        }
    }
}

