/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.CommentNode;
import net.sourceforge.pmd.lang.rule.xpath.TextNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstAttributeNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstNodeOwner;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstTreeInfo;
import net.sourceforge.pmd.lang.rule.xpath.internal.BaseNodeInfo;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AstElementNode
extends BaseNodeInfo
implements SiblingCountingNode,
AstNodeOwner {
    private final Node wrappedNode;
    private final int id;
    private final List<AstElementNode> children;
    private @Nullable Map<String, AstAttributeNode> attributes;
    private @Nullable Map<String, Attribute> lightAttributes;

    AstElementNode(AstTreeInfo document, MutableInt idGenerator, BaseNodeInfo parent, Node wrappedNode, Configuration configuration) {
        super(AstElementNode.determineType(wrappedNode), configuration.getNamePool(), wrappedNode.getXPathNodeName(), parent);
        this.treeInfo = document;
        this.wrappedNode = wrappedNode;
        this.id = idGenerator.getAndIncrement();
        this.children = new ArrayList<AstElementNode>(wrappedNode.getNumChildren());
        for (int i = 0; i < wrappedNode.getNumChildren(); ++i) {
            this.children.add(new AstElementNode(document, idGenerator, this, wrappedNode.getChild(i), configuration));
        }
    }

    private static int determineType(Node node) {
        if (node instanceof TextNode) {
            return 3;
        }
        if (node instanceof CommentNode) {
            return 8;
        }
        return 1;
    }

    public Map<String, AstAttributeNode> makeAttributes(Node wrappedNode) {
        HashMap<String, AstAttributeNode> atts = new HashMap<String, AstAttributeNode>();
        Iterator<Attribute> it = wrappedNode.getXPathAttributesIterator();
        int attrIdx = 0;
        while (it.hasNext()) {
            Attribute next = it.next();
            atts.put(next.getName(), new AstAttributeNode(this, next, attrIdx++));
        }
        return atts;
    }

    public Map<String, AstAttributeNode> getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.makeAttributes(this.getUnderlyingNode());
        }
        return this.attributes;
    }

    public Map<String, Attribute> getLightAttributes() {
        if (this.lightAttributes == null) {
            this.lightAttributes = new HashMap<String, Attribute>();
            this.getUnderlyingNode().getXPathAttributesIterator().forEachRemaining(it -> this.lightAttributes.put(it.getName(), (Attribute)it));
        }
        return this.lightAttributes;
    }

    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    @Override
    List<AstElementNode> getChildren() {
        return this.children;
    }

    @Override
    public Node getUnderlyingNode() {
        return this.wrappedNode;
    }

    public int getColumnNumber() {
        return this.wrappedNode.getBeginColumn();
    }

    public int getSiblingPosition() {
        BaseNodeInfo parent = this.getParent();
        return !(parent instanceof AstElementNode) ? 0 : this.id - ((AstElementNode)parent).id;
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof AstElementNode) {
            return Integer.compare(this.id, ((AstElementNode)other).id);
        }
        if (other instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)other));
        }
        throw new UnsupportedOperationException();
    }

    protected AxisIterator iterateAttributes(Predicate<? super NodeInfo> predicate) {
        if (predicate instanceof NameTest) {
            String local = ((NameTest)predicate).getLocalPart();
            return SingleNodeIterator.makeIterator((NodeInfo)((NodeInfo)this.getAttributes().get(local)));
        }
        return AstElementNode.filter(predicate, new IteratorAdapter(this.getAttributes().values().iterator()));
    }

    protected AxisIterator iterateChildren(Predicate<? super NodeInfo> nodeTest) {
        return AstElementNode.filter(nodeTest, AstElementNode.iterateList(this.children));
    }

    protected AxisIterator iterateSiblings(Predicate<? super NodeInfo> nodeTest, boolean forwards) {
        if (this.parent == null) {
            return EmptyIterator.ofNodes();
        }
        List<AstElementNode> siblingsList = forwards ? CollectionUtil.drop(this.parent.getChildren(), this.wrappedNode.getIndexInParent() + 1) : CollectionUtil.take(this.parent.getChildren(), this.wrappedNode.getIndexInParent());
        return AstElementNode.filter(nodeTest, AstElementNode.iterateList(siblingsList, forwards));
    }

    public String getAttributeValue(String uri, String local) {
        Attribute attribute = this.getLightAttributes().get(local);
        if (attribute != null) {
            this.getTreeInfo().getLogger().recordUsageOf(attribute);
            return attribute.getStringValue();
        }
        return null;
    }

    public int getLineNumber() {
        return this.wrappedNode.getBeginLine();
    }

    public NodeInfo getRoot() {
        return this.getTreeInfo().getRootNode();
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append(Integer.toString(this.id));
    }

    public String getLocalPart() {
        return this.wrappedNode.getXPathNodeName();
    }

    public CharSequence getStringValueCS() {
        Node node = this.getUnderlyingNode();
        if (node instanceof TextNode) {
            return ((TextNode)node).getText();
        }
        if (node instanceof CommentNode) {
            return ((CommentNode)node).getData();
        }
        return node.descendants(TextNode.class).toStream().map(TextNode::getText).collect(Collectors.joining(""));
    }

    public String toString() {
        return "Wrapper[" + this.getLocalPart() + "]@" + this.hashCode();
    }

    private static class IteratorAdapter
    implements AxisIterator,
    LookaheadIterator {
        private static final EnumSet<SequenceIterator.Property> PROPERTIES = EnumSet.of(SequenceIterator.Property.LOOKAHEAD);
        private final Iterator<? extends NodeInfo> it;

        IteratorAdapter(Iterator<? extends NodeInfo> it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public NodeInfo next() {
            return this.it.hasNext() ? this.it.next() : null;
        }

        public void close() {
        }

        public EnumSet<SequenceIterator.Property> getProperties() {
            return PROPERTIES;
        }
    }
}

