/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.List;
import java.util.function.Predicate;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstTreeInfo;

abstract class BaseNodeInfo
extends AbstractNodeWrapper
implements SiblingCountingNode {
    private final int nodeKind;
    private final NamePool namePool;
    private final int fingerprint;
    protected final BaseNodeInfo parent;

    BaseNodeInfo(int nodeKind, NamePool namePool, String localName, BaseNodeInfo parent) {
        this.nodeKind = nodeKind;
        this.namePool = namePool;
        this.fingerprint = namePool.allocateFingerprint("", localName) & 0xFFFFF;
        this.parent = parent;
    }

    abstract List<AstElementNode> getChildren();

    public AstTreeInfo getTreeInfo() {
        return (AstTreeInfo)this.treeInfo;
    }

    public final String getURI() {
        return "";
    }

    public final String getBaseURI() {
        return "";
    }

    public String getPrefix() {
        return "";
    }

    public final BaseNodeInfo getParent() {
        return this.parent;
    }

    public final int getFingerprint() {
        return this.fingerprint;
    }

    public final boolean hasFingerprint() {
        return true;
    }

    public final NamePool getNamePool() {
        return this.namePool;
    }

    public final int getNodeKind() {
        return this.nodeKind;
    }

    protected static AxisIterator filter(Predicate<? super NodeInfo> nodeTest, AxisIterator iter) {
        return nodeTest == null || nodeTest instanceof AnyNodeTest ? iter : new Navigator.AxisFilter(iter, nodeTest);
    }

    static AxisIterator iterateList(List<? extends NodeInfo> nodes) {
        return BaseNodeInfo.iterateList(nodes, true);
    }

    static AxisIterator iterateList(List<? extends NodeInfo> nodes, boolean forwards) {
        return forwards ? new ListIterator.OfNodes(nodes) : new RevListAxisIterator(nodes);
    }

    private static class RevListAxisIterator
    extends ReverseListIterator<NodeInfo>
    implements AxisIterator {
        RevListAxisIterator(List<NodeInfo> list) {
            super(list);
        }
    }
}

