/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;
import net.sourceforge.pmd.properties.internal.PropertyTypeId;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PropertyBuilder<B extends PropertyBuilder<B, T>, T> {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][\\w-]*");
    private final String name;
    private String description;
    private T defaultValue;
    protected @Nullable PropertyTypeId typeId;
    protected boolean isXPathAvailable = false;

    PropertyBuilder(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name must be provided");
        }
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name '" + name + "'");
        }
        this.name = name;
    }

    String getDescription() {
        if (!this.isDescriptionSet()) {
            throw new IllegalArgumentException("Description must be provided");
        }
        return this.description;
    }

    boolean isDescriptionSet() {
        return StringUtils.isNotBlank((CharSequence)this.description);
    }

    T getDefaultValue() {
        if (!this.isDefaultValueSet()) {
            throw new IllegalArgumentException("A default value must be provided");
        }
        return this.defaultValue;
    }

    boolean isDefaultValueSet() {
        return this.defaultValue != null;
    }

    public B desc(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            throw new IllegalArgumentException("Description must be provided");
        }
        this.description = desc;
        return (B)this;
    }

    B typeId(PropertyTypeId typeId) {
        this.typeId = typeId;
        return (B)this;
    }

    public B availableInXPath(boolean b) {
        this.isXPathAvailable = b;
        return (B)this;
    }

    public abstract B require(PropertyConstraint<? super T> var1);

    public B defaultValue(@NonNull T val) {
        if (val == null) {
            throw new IllegalArgumentException("Property values may not be null.");
        }
        this.defaultValue = val;
        return (B)this;
    }

    public abstract PropertyDescriptor<T> build();

    public String getName() {
        return this.name;
    }

    public static final class GenericCollectionPropertyBuilder<V, C extends Iterable<V>>
    extends PropertyBuilder<GenericCollectionPropertyBuilder<V, C>, C> {
        private PropertySerializer<V> itemParser;
        private final Collector<? super V, ?, ? extends C> collector;
        private final List<PropertyConstraint<? super C>> collectionConstraints = new ArrayList<PropertyConstraint<? super C>>();

        GenericCollectionPropertyBuilder(String name, PropertySerializer<V> itemParser, Collector<? super V, ?, ? extends C> collector) {
            super(name);
            this.itemParser = itemParser;
            this.collector = collector;
        }

        private C getDefaultValue(Iterable<? extends V> list) {
            return (C)((Iterable)IteratorUtil.toStream(list).collect(this.collector));
        }

        @Override
        public GenericCollectionPropertyBuilder<V, C> require(PropertyConstraint<? super C> constraint) {
            this.collectionConstraints.add(constraint);
            return this;
        }

        @Override
        public GenericCollectionPropertyBuilder<V, C> defaultValue(Iterable<? extends V> val) {
            super.defaultValue(this.getDefaultValue(val));
            return this;
        }

        public GenericCollectionPropertyBuilder<V, C> defaultValues(V head, V ... tail) {
            return this.defaultValue((Iterable<? extends V>)CollectionUtil.listOf(head, tail));
        }

        public GenericCollectionPropertyBuilder<V, C> emptyDefaultValue() {
            return this.defaultValue(Collections.emptyList());
        }

        public GenericCollectionPropertyBuilder<V, C> requireEach(PropertyConstraint<? super V> constraint) {
            this.itemParser = this.itemParser.withConstraint(constraint);
            return this;
        }

        @Override
        public PropertyDescriptor<C> build() {
            PropertySerializer<? extends C> syntax = PropertyParsingUtil.delimitedString(this.itemParser, this.collector);
            syntax = PropertyParsingUtil.withAllConstraints(syntax, CollectionUtil.map(this.itemParser.getConstraints(), PropertyConstraint::toCollectionConstraint));
            syntax = PropertyParsingUtil.withAllConstraints(syntax, this.collectionConstraints);
            return new PropertyDescriptor<C>(this.getName(), this.getDescription(), (Iterable)this.getDefaultValue(), syntax, this.typeId, this.isXPathAvailable);
        }
    }

    public static final class RegexPropertyBuilder
    extends BaseSinglePropertyBuilder<RegexPropertyBuilder, Pattern> {
        RegexPropertyBuilder(String name) {
            super(name, PropertyParsingUtil.REGEX);
        }

        @Override
        public RegexPropertyBuilder defaultValue(String pattern) {
            super.defaultValue(Pattern.compile(pattern));
            return this;
        }

        public RegexPropertyBuilder defaultValue(String pattern, int flags) {
            super.defaultValue(Pattern.compile(pattern, flags));
            return this;
        }
    }

    public static class GenericPropertyBuilder<T>
    extends BaseSinglePropertyBuilder<GenericPropertyBuilder<T>, T> {
        GenericPropertyBuilder(String name, PropertySerializer<T> parser) {
            super(name, parser);
        }
    }

    static abstract class BaseSinglePropertyBuilder<B extends PropertyBuilder<B, T>, T>
    extends PropertyBuilder<B, T> {
        private PropertySerializer<T> parser;

        BaseSinglePropertyBuilder(String name, PropertySerializer<T> parser) {
            super(name);
            this.parser = parser;
        }

        protected PropertySerializer<T> getParser() {
            return this.parser;
        }

        @Override
        public B require(PropertyConstraint<? super T> constraint) {
            this.parser = this.parser.withConstraint(constraint);
            return (B)this;
        }

        public GenericCollectionPropertyBuilder<T, List<T>> toList() {
            return this.map(Collectors.toList());
        }

        public <C extends Iterable<T>> GenericCollectionPropertyBuilder<T, C> map(Collector<? super T, ?, ? extends C> collector) {
            if (this.isDefaultValueSet()) {
                throw new IllegalStateException("The default value is already set!");
            }
            GenericCollectionPropertyBuilder<T, C> result = new GenericCollectionPropertyBuilder<T, C>(this.getName(), this.getParser(), collector);
            if (this.isDescriptionSet()) {
                result.desc(this.getDescription());
            }
            return result;
        }

        public GenericPropertyBuilder<Optional<T>> toOptional(String missingValue) {
            AssertionUtil.requireParamNotNull("missingValue", missingValue);
            PropertySerializer<Optional<T>> serializer = PropertyParsingUtil.toOptional(this.getParser(), missingValue);
            GenericPropertyBuilder result = new GenericPropertyBuilder(this.getName(), serializer);
            if (this.isDefaultValueSet()) {
                result.defaultValue(Optional.of(this.getDefaultValue()));
            }
            if (this.isDescriptionSet()) {
                result.desc(this.getDescription());
            }
            return result;
        }

        @Override
        public PropertyDescriptor<T> build() {
            return new PropertyDescriptor(this.getName(), this.getDescription(), this.getDefaultValue(), this.parser, this.typeId, this.isXPathAvailable);
        }
    }
}

