/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.sourceforge.pmd.properties.ConstraintViolatedException;
import org.apache.commons.lang3.StringUtils;

public interface PropertyConstraint<T> {
    public void validate(T var1);

    public String getConstraintDescription();

    default public Map<String, String> getXmlConstraint() {
        return Collections.emptyMap();
    }

    default public PropertyConstraint<Optional<? extends T>> toOptionalConstraint() {
        return new PropertyConstraint<Optional<? extends T>>(){

            @Override
            public void validate(Optional<? extends T> value) {
                value.ifPresent(PropertyConstraint.this::validate);
            }

            @Override
            public String getConstraintDescription() {
                return PropertyConstraint.this.getConstraintDescription();
            }
        };
    }

    default public PropertyConstraint<Iterable<? extends T>> toCollectionConstraint() {
        return new PropertyConstraint<Iterable<? extends T>>(){

            @Override
            public void validate(Iterable<? extends T> value) {
                for (Object t : value) {
                    PropertyConstraint.this.validate(t);
                }
            }

            @Override
            public String getConstraintDescription() {
                return "Components " + StringUtils.uncapitalize((String)PropertyConstraint.this.getConstraintDescription());
            }
        };
    }

    public static <U> PropertyConstraint<U> fromPredicate(Predicate<? super U> pred, String constraintDescription) {
        return PropertyConstraint.fromPredicate(pred, constraintDescription, Collections.emptyMap());
    }

    public static <U> PropertyConstraint<U> fromPredicate(final Predicate<? super U> pred, final String constraintDescription, final Map<String, String> xmlConstraint) {
        return new PropertyConstraint<U>(){

            @Override
            public void validate(U value) {
                if (!pred.test(value)) {
                    throw new ConstraintViolatedException(this, value);
                }
            }

            @Override
            public String getConstraintDescription() {
                return StringUtils.capitalize((String)constraintDescription);
            }

            public String toString() {
                return "PropertyConstraint(" + constraintDescription + ")";
            }

            @Override
            public Map<String, String> getXmlConstraint() {
                return xmlConstraint;
            }
        };
    }
}

