/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.ParametricRuleViolation;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.reporting.ViolationDecorator;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RuleContext {
    private static final Object[] NO_ARGS = new Object[0];
    private static final List<ViolationSuppressor> DEFAULT_SUPPRESSORS = CollectionUtil.listOf(ViolationSuppressor.NOPMD_COMMENT_SUPPRESSOR, ViolationSuppressor.REGEX_SUPPRESSOR, ViolationSuppressor.XPATH_SUPPRESSOR);
    private final FileAnalysisListener listener;
    private final Rule rule;

    RuleContext(FileAnalysisListener listener, Rule rule) {
        Objects.requireNonNull(listener, "Listener was null");
        Objects.requireNonNull(rule, "Rule was null");
        this.listener = listener;
        this.rule = rule;
    }

    Rule getRule() {
        return this.rule;
    }

    private String getDefaultMessage() {
        return this.rule.getMessage();
    }

    public void addViolation(Node location) {
        this.addViolationWithMessage(location, this.getDefaultMessage(), NO_ARGS);
    }

    public void addViolation(Node location, Object ... formatArgs) {
        this.addViolationWithMessage(location, this.getDefaultMessage(), formatArgs);
    }

    public void addViolationWithMessage(Node location, String message) {
        this.addViolationWithPosition(location, -1, -1, message, NO_ARGS);
    }

    public void addViolationWithMessage(Node location, String message, Object ... formatArgs) {
        this.addViolationWithPosition(location, -1, -1, message, formatArgs);
    }

    public void addViolationWithPosition(Node node, int beginLine, int endLine, String message, Object ... formatArgs) {
        Map<String, String> extraVariables;
        String description;
        ParametricRuleViolation violation;
        Report.SuppressedViolation suppressed;
        Objects.requireNonNull(node, "Node was null");
        Objects.requireNonNull(message, "Message was null");
        Objects.requireNonNull(formatArgs, "Format arguments were null, use an empty array");
        LanguageVersionHandler handler = node.getAstInfo().getLanguageProcessor().services();
        FileLocation location = node.getReportLocation();
        if (beginLine != -1 && endLine != -1) {
            location = FileLocation.range(location.getFileId(), TextRange2d.range2d(beginLine, 1, endLine, 1));
        }
        if ((suppressed = RuleContext.suppressOrNull(node, violation = new ParametricRuleViolation(this.rule, location, description = this.makeMessage(message, formatArgs, extraVariables = ViolationDecorator.apply(handler.getViolationDecorator(), node)), extraVariables), handler)) != null) {
            this.listener.onSuppressedRuleViolation(suppressed);
        } else {
            this.listener.onRuleViolation(violation);
        }
    }

    private static @Nullable Report.SuppressedViolation suppressOrNull(Node location, RuleViolation rv, LanguageVersionHandler handler) {
        Report.SuppressedViolation suppressed = ViolationSuppressor.suppressOrNull(handler.getExtraViolationSuppressors(), rv, location);
        if (suppressed == null) {
            suppressed = ViolationSuppressor.suppressOrNull(DEFAULT_SUPPRESSORS, rv, location);
        }
        return suppressed;
    }

    private String makeMessage(@NonNull String message, Object[] args, Map<String, String> extraVars) {
        String escapedMessage = StringUtils.replace((String)message, (String)"${", (String)"$'{'");
        String formatted = MessageFormat.format(escapedMessage, args);
        return this.expandVariables(formatted, extraVars);
    }

    private String expandVariables(String message, Map<String, String> extraVars) {
        if (!message.contains("${")) {
            return message;
        }
        StringBuilder buf = new StringBuilder(message);
        int startIndex = -1;
        while ((startIndex = buf.indexOf("${", startIndex + 1)) >= 0) {
            String name;
            String variableValue;
            int endIndex = buf.indexOf("}", startIndex);
            if (endIndex < 0 || (variableValue = this.getVariableValue(name = buf.substring(startIndex + 2, endIndex), extraVars)) == null) continue;
            buf.replace(startIndex, endIndex + 1, variableValue);
        }
        return buf.toString();
    }

    private String getVariableValue(String name, Map<String, String> extraVars) {
        String value = extraVars.get(name);
        if (value != null) {
            return value;
        }
        PropertyDescriptor<?> propertyDescriptor = this.rule.getPropertyDescriptor(name);
        return propertyDescriptor == null ? null : String.valueOf(this.rule.getProperty(propertyDescriptor));
    }
}

