/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DataMap<K> {
    private Map<DataKey<? extends K, ?>, Object> map;

    private DataMap() {
    }

    public <T> @Nullable T set(DataKey<? extends K, ? super T> key, T data) {
        return (T)this.getMap().put(key, data);
    }

    public <T> @Nullable T get(DataKey<? extends K, ? extends T> key) {
        return (T)(this.map == null ? null : this.map.get(key));
    }

    public <T> T getOrDefault(DataKey<? extends K, ? extends T> key, T defaultValue) {
        return (T)(this.map == null ? defaultValue : this.map.getOrDefault(key, defaultValue));
    }

    public <T> T computeIfAbsent(DataKey<? extends K, T> key, Supplier<? extends T> supplier) {
        return (T)this.getMap().computeIfAbsent(key, (? super K k) -> supplier.get());
    }

    public <T> T compute(DataKey<? extends K, T> key, Function<? super @Nullable T, ? extends T> function) {
        return (T)this.getMap().compute(key, (? super K k, ? super V v) -> function.apply(v));
    }

    private Map<DataKey<? extends K, ?>, Object> getMap() {
        if (this.map == null) {
            this.map = new IdentityHashMap(1);
        }
        return this.map;
    }

    public boolean isSet(DataKey<? extends K, ?> key) {
        return this.map != null && this.map.containsKey(key);
    }

    public static <K> DataMap<K> newDataMap() {
        return new DataMap<K>();
    }

    public static <T> SimpleDataKey<T> simpleDataKey(String name) {
        return new SimpleDataKey(name);
    }

    public static class SimpleDataKey<T>
    implements DataKey<SimpleDataKey<T>, T> {
        private final String name;

        SimpleDataKey(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface DataKey<K extends DataKey<K, T>, T> {
    }
}

