/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log;

import java.text.MessageFormat;
import net.sourceforge.pmd.util.log.internal.QuietReporter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.event.Level;

public interface PmdReporter {
    public boolean isLoggable(Level var1);

    default public void log(Level level, String message, Object ... formatArgs) {
        this.logEx(level, message, formatArgs, null);
    }

    public void logEx(Level var1, @Nullable String var2, Object[] var3, @Nullable Throwable var4);

    default public RuntimeException newException(Level level, @Nullable Throwable cause, @Nullable String message, Object ... formatArgs) {
        this.logEx(level, message, formatArgs, cause);
        if (message == null) {
            return new RuntimeException(cause);
        }
        return new RuntimeException(MessageFormat.format(message, formatArgs), cause);
    }

    default public void info(String message, Object ... formatArgs) {
        this.log(Level.INFO, message, formatArgs);
    }

    default public void warn(String message, Object ... formatArgs) {
        this.log(Level.WARN, message, formatArgs);
    }

    default public void warnEx(String message, Throwable error) {
        this.logEx(Level.WARN, message, new Object[0], error);
    }

    default public void warnEx(String message, Object[] formatArgs, Throwable error) {
        this.logEx(Level.WARN, message, formatArgs, error);
    }

    default public RuntimeException error(String message, Object ... formatArgs) {
        return this.error(null, message, formatArgs);
    }

    default public RuntimeException error(@Nullable Throwable cause, @Nullable String contextMessage, Object ... formatArgs) {
        return this.newException(Level.ERROR, cause, contextMessage, formatArgs);
    }

    default public RuntimeException error(Throwable error) {
        return this.error(error, null, new Object[0]);
    }

    default public void errorEx(String message, Throwable error) {
        this.logEx(Level.ERROR, message, new Object[0], error);
    }

    default public void errorEx(String message, Object[] formatArgs, Throwable error) {
        this.logEx(Level.ERROR, message, formatArgs, error);
    }

    public int numErrors();

    public static PmdReporter quiet() {
        return new QuietReporter();
    }
}

