/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log.internal;

import java.text.MessageFormat;
import java.util.Objects;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.event.Level;

public abstract class MessageReporterBase
implements PmdReporter {
    private int numErrors;
    private @Nullable Level minLevel = Level.TRACE;

    public final void setLevel(@Nullable Level minLevel) {
        this.minLevel = minLevel;
    }

    @Override
    public final boolean isLoggable(Level level) {
        return this.minLevel != null && this.minLevel.compareTo((Enum)level) >= 0 && this.isLoggableImpl(level);
    }

    protected boolean isLoggableImpl(Level level) {
        return true;
    }

    @Override
    public void logEx(Level level, @Nullable String message, Object[] formatArgs, @Nullable Throwable error) {
        if (this.isLoggable(level)) {
            if (error == null) {
                Objects.requireNonNull(message, "cannot call this method with null message and error");
                this.log(level, message, formatArgs);
                return;
            }
            if (level == Level.ERROR) {
                ++this.numErrors;
            }
            String fullMessage = this.getErrorMessage(error);
            if (message != null) {
                message = MessageFormat.format(message, formatArgs);
                fullMessage = message + ": " + fullMessage;
            }
            this.logImpl(level, fullMessage);
            if (this.isLoggable(Level.DEBUG)) {
                String stackTrace = StringUtil.quoteMessageFormat(ExceptionUtils.getStackTrace((Throwable)error));
                this.log(Level.DEBUG, stackTrace, new Object[0]);
            }
        } else if (level == Level.ERROR) {
            ++this.numErrors;
        }
    }

    private @NonNull String getErrorMessage(Throwable error) {
        String errorMessage = error.getMessage();
        if (errorMessage == null) {
            errorMessage = error.getClass().getSimpleName();
        }
        return errorMessage;
    }

    @Override
    public final void log(Level level, String message, Object ... formatArgs) {
        if (level == Level.ERROR) {
            ++this.numErrors;
        }
        if (this.isLoggable(level)) {
            this.logImpl(level, MessageFormat.format(message, formatArgs));
        }
    }

    protected abstract void logImpl(Level var1, String var2);

    @Override
    public int numErrors() {
        return this.numErrors;
    }
}

