/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log.internal;

import net.sourceforge.pmd.util.log.PmdReporter;
import net.sourceforge.pmd.util.log.internal.MessageReporterBase;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class SimpleMessageReporter
extends MessageReporterBase
implements PmdReporter {
    private final Logger backend;

    public SimpleMessageReporter(Logger backend) {
        this.backend = backend;
    }

    @Override
    protected boolean isLoggableImpl(Level level) {
        switch (level) {
            case ERROR: {
                return this.backend.isErrorEnabled();
            }
            case WARN: {
                return this.backend.isWarnEnabled();
            }
            case INFO: {
                return this.backend.isInfoEnabled();
            }
            case DEBUG: {
                return this.backend.isDebugEnabled();
            }
            case TRACE: {
                return this.backend.isTraceEnabled();
            }
        }
        return false;
    }

    @Override
    protected void logImpl(Level level, String message) {
        switch (level) {
            case ERROR: {
                this.backend.error(message);
                break;
            }
            case WARN: {
                this.backend.warn(message);
                break;
            }
            case INFO: {
                this.backend.info(message);
                break;
            }
            case DEBUG: {
                this.backend.debug(message);
                break;
            }
            case TRACE: {
                this.backend.trace(message);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid log level: " + level));
            }
        }
    }
}

