/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class JUnitAssertionsShouldIncludeMessageRule
extends AbstractJavaRule {
    private static final String JUNIT3_PACKAGE = "junit.framework";
    private static final String JUNIT4_PACKAGE = "org.junit";
    private List<AssertionCall> checks = new ArrayList<AssertionCall>();
    private boolean isJUnit;

    public JUnitAssertionsShouldIncludeMessageRule() {
        this.checks.add(new AssertionCall("assertArrayEquals", 2));
        this.checks.add(new AssertionCall("assertEquals", 2));
        this.checks.add(new AssertionCall("assertFalse", 1));
        this.checks.add(new AssertionCall("assertNotNull", 1));
        this.checks.add(new AssertionCall("assertNotSame", 2));
        this.checks.add(new AssertionCall("assertNull", 1));
        this.checks.add(new AssertionCall("assertSame", 2));
        this.checks.add(new AssertionCall("assertThat", 2));
        this.checks.add(new AssertionCall("assertTrue", 1));
        this.checks.add(new AssertionCall("fail", 0));
        this.checks.add(new AssertionCall("assertEquals", 3){

            @Override
            protected boolean isException(ASTArguments node) {
                ASTArgumentList argumentList = (ASTArgumentList)node.getFirstChildOfType(ASTArgumentList.class);
                List arguments = argumentList.findChildrenOfType(ASTExpression.class);
                boolean isExceptionJunit4 = JUnitAssertionsShouldIncludeMessageRule.this.isStringTypeOrNull((ASTExpression)arguments.get(0));
                boolean isExceptionJunit5 = JUnitAssertionsShouldIncludeMessageRule.this.isStringTypeOrNull((ASTExpression)arguments.get(2));
                return isExceptionJunit4 || isExceptionJunit5;
            }
        });
    }

    public void start(RuleContext ctx) {
        super.start(ctx);
        this.isJUnit = false;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        this.isJUnit |= node.getImportedName().startsWith(JUNIT4_PACKAGE);
        this.isJUnit |= node.getImportedName().startsWith(JUNIT3_PACKAGE);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTExtendsList node, Object data) {
        for (ASTClassOrInterfaceType type : node) {
            this.isJUnit |= type.getImage().startsWith(JUNIT3_PACKAGE);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTAnnotation node, Object data) {
        this.isJUnit |= node.getAnnotationName().startsWith(JUNIT4_PACKAGE);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTArguments node, Object data) {
        if (this.isJUnit) {
            for (AssertionCall call : this.checks) {
                JavaNode foundAssertCall = call.check(data, node);
                if (foundAssertCall == null) continue;
                this.addViolation(data, (Node)foundAssertCall);
            }
        }
        return super.visit(node, data);
    }

    private boolean isStringTypeOrNull(ASTExpression node) {
        return node.getType() == String.class || node.getType() == null;
    }

    private static class AssertionCall {
        private final int argumentsCount;
        private final String assertionName;

        AssertionCall(String assertionName, int argumentsCount) {
            this.argumentsCount = argumentsCount;
            this.assertionName = assertionName;
        }

        public JavaNode check(Object ctx, ASTArguments node) {
            if (node.size() == this.argumentsCount && node.getNthParent(2) instanceof ASTPrimaryExpression) {
                ASTName name;
                ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)node.getNthParent(2).getFirstChildOfType(ASTPrimaryPrefix.class);
                if (this.isException(node)) {
                    return null;
                }
                if (primaryPrefix != null && (name = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class)) != null && (name.hasImageEqualTo(this.assertionName) || name.getImage().endsWith("Assert." + this.assertionName))) {
                    return name;
                }
            }
            return null;
        }

        public String toString() {
            return "Assertion[" + this.assertionName + ",args=" + this.argumentsCount + "]";
        }

        protected boolean isException(ASTArguments node) {
            return false;
        }
    }
}

