/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameterList;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaExpr;
import net.sourceforge.pmd.lang.java.ast.AstImplUtil;
import net.sourceforge.pmd.lang.java.ast.FunctionalExpression;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTLambdaExpression
extends AbstractJavaExpr
implements FunctionalExpression {
    private JMethodSig functionalMethod;

    ASTLambdaExpression(int id) {
        super(id);
    }

    @Override
    public @NonNull JTypeMirror getTypeMirror() {
        return super.getTypeMirror();
    }

    @Override
    public JMethodSig getFunctionalMethod() {
        this.forceTypeResolution();
        return this.assertNonNullAfterTypeRes(this.functionalMethod);
    }

    void setFunctionalMethod(@Nullable JMethodSig functionalMethod) {
        this.functionalMethod = functionalMethod;
    }

    public ASTLambdaParameterList getParameters() {
        return (ASTLambdaParameterList)this.getChild(0);
    }

    public boolean isBlockBody() {
        return this.getChild(1) instanceof ASTBlock;
    }

    public boolean isExpressionBody() {
        return !this.isBlockBody();
    }

    public @Nullable ASTBlock getBlock() {
        return AstImplUtil.getChildAs(this, 1, ASTBlock.class);
    }

    public @Nullable ASTExpression getExpression() {
        return AstImplUtil.getChildAs(this, 1, ASTExpression.class);
    }

    public @Nullable ASTBlock getBlockBody() {
        return (ASTBlock)NodeStream.of((Node)((JavaNode)this.getLastChild())).filterIs(ASTBlock.class).first();
    }

    public @Nullable ASTExpression getExpressionBody() {
        return (ASTExpression)NodeStream.of((Node)((JavaNode)this.getLastChild())).filterIs(ASTExpression.class).first();
    }

    public boolean isFindBoundary() {
        return true;
    }

    public int getArity() {
        return this.getParameters().size();
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }
}

