/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.internal.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;

public class UnusedPrivateMethodRule
extends AbstractIgnoredAnnotationRule {
    private static final Set<String> SERIALIZATION_METHODS = CollectionUtil.setOf((Object)"readObject", (Object[])new String[]{"writeObject", "readResolve", "writeReplace"});

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Collections.singletonList("java.lang.Deprecated");
    }

    public Object visit(ASTCompilationUnit file, Object param) {
        Set methodsUsedByAnnotations = file.descendants(ASTMethodDeclaration.class).children(ASTModifierList.class).children(ASTAnnotation.class).filter(t -> TypeTestUtil.isA("org.junit.jupiter.params.provider.MethodSource", (TypeNode)t)).descendants(ASTStringLiteral.class).toStream().map(ASTStringLiteral::getConstValue).collect(Collectors.toSet());
        Map consideredNames = file.descendants(ASTMethodDeclaration.class).crossFindBoundaries().filter(it -> it.getVisibility() == ModifierOwner.Visibility.V_PRIVATE).filter(it -> !this.hasIgnoredAnnotation((Annotatable)it) && !this.hasExcludedName((ASTMethodDeclaration)it) && (it.getArity() != 0 || !methodsUsedByAnnotations.contains(it.getName()))).toStream().collect(Collectors.groupingBy(ASTMethodDeclaration::getName, HashMap::new, CollectionUtil.toMutableSet()));
        file.descendants().crossFindBoundaries().map(NodeStream.asInstanceOf(ASTMethodCall.class, (Class[])new Class[]{ASTMethodReference.class})).forEach(ref -> {
            Set remainingUnused;
            JExecutableSymbol sym;
            String methodName = ref.getMethodName();
            if (!consideredNames.containsKey(methodName)) {
                return;
            }
            if (ref instanceof ASTMethodCall) {
                sym = ((ASTMethodCall)ref).getMethodType().getSymbol();
            } else if (ref instanceof ASTMethodReference) {
                sym = ((ASTMethodReference)ref).getReferencedMethod().getSymbol();
            } else {
                return;
            }
            JavaNode reffed = sym.tryGetNode();
            if (reffed instanceof ASTMethodDeclaration && ref.ancestors(ASTMethodDeclaration.class).first() != reffed && (remainingUnused = (Set)consideredNames.get(methodName)) != null && remainingUnused.remove(reffed) && remainingUnused.isEmpty()) {
                consideredNames.remove(methodName);
            }
        });
        consideredNames.forEach((name, unused) -> {
            for (ASTMethodDeclaration m : unused) {
                this.asCtx(param).addViolation((Node)m, new Object[]{PrettyPrintingUtil.displaySignature(m)});
            }
        });
        return null;
    }

    private boolean hasExcludedName(ASTMethodDeclaration node) {
        return SERIALIZATION_METHODS.contains(node.getName());
    }
}

