/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ClassNamingConventionsRule
extends AbstractNamingConventionRule<ASTTypeDeclaration> {
    private final PropertyDescriptor<Pattern> classRegex = this.defaultProp("class", "concrete class").build();
    private final PropertyDescriptor<Pattern> abstractClassRegex = this.defaultProp("abstract class").build();
    private final PropertyDescriptor<Pattern> interfaceRegex = this.defaultProp("interface").build();
    private final PropertyDescriptor<Pattern> enumerationRegex = this.defaultProp("enum").build();
    private final PropertyDescriptor<Pattern> annotationRegex = this.defaultProp("annotation").build();
    private final PropertyDescriptor<Pattern> utilityClassRegex = this.defaultProp("utility class").build();
    private final PropertyDescriptor<Pattern> testClassRegex = ((PropertyBuilder.RegexPropertyBuilder)this.defaultProp("test class").desc("Regex which applies to test class names. Since PMD 6.52.0.")).defaultValue("^Test.*$|^[A-Z][a-zA-Z0-9]*Test(s|Case)?$").build();

    public ClassNamingConventionsRule() {
        super(ASTClassDeclaration.class, ASTEnumDeclaration.class, ASTAnnotationTypeDeclaration.class, ASTRecordDeclaration.class);
        this.definePropertyDescriptor(this.classRegex);
        this.definePropertyDescriptor(this.abstractClassRegex);
        this.definePropertyDescriptor(this.interfaceRegex);
        this.definePropertyDescriptor(this.enumerationRegex);
        this.definePropertyDescriptor(this.annotationRegex);
        this.definePropertyDescriptor(this.utilityClassRegex);
        this.definePropertyDescriptor(this.testClassRegex);
    }

    private boolean isTestClass(ASTClassDeclaration node) {
        return !node.isNested() && TestFrameworksUtil.isTestClass(node);
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (node.isAbstract()) {
            this.checkMatches(node, this.abstractClassRegex, data);
        } else if (this.isTestClass(node)) {
            this.checkMatches(node, this.testClassRegex, data);
        } else if (JavaRuleUtil.isUtilityClass(node)) {
            this.checkMatches(node, this.utilityClassRegex, data);
        } else if (node.isInterface()) {
            this.checkMatches(node, this.interfaceRegex, data);
        } else {
            this.checkMatches(node, this.classRegex, data);
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        this.checkMatches(node, this.enumerationRegex, data);
        return data;
    }

    public Object visit(ASTRecordDeclaration node, Object data) {
        this.checkMatches(node, this.classRegex, data);
        return data;
    }

    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        this.checkMatches(node, this.annotationRegex, data);
        return data;
    }

    @Override
    String defaultConvention() {
        return "[A-Z][a-zA-Z0-9]*";
    }

    @Override
    String nameExtractor(ASTTypeDeclaration node) {
        return node.getSimpleName();
    }

    @Override
    String kindDisplayName(ASTTypeDeclaration node, PropertyDescriptor<Pattern> descriptor) {
        return JavaRuleUtil.isUtilityClass(node) ? "utility class" : PrettyPrintingUtil.getPrintableNodeKind(node);
    }
}

