/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NullAssignmentRule
extends AbstractJavaRulechainRule {
    public NullAssignmentRule() {
        super(ASTNullLiteral.class, new Class[0]);
    }

    public Object visit(ASTNullLiteral node, Object data) {
        if (node.getParent() instanceof ASTAssignmentExpression) {
            ASTAssignmentExpression assignment = (ASTAssignmentExpression)node.getParent();
            if (this.isAssignmentToFinal(assignment)) {
                return data;
            }
            if (assignment.getRightOperand() == node) {
                this.asCtx(data).addViolation((Node)node);
            }
        } else if (node.getParent() instanceof ASTConditionalExpression && this.isBadTernary((ASTConditionalExpression)node.getParent(), node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private boolean isAssignmentToFinal(ASTAssignmentExpression n) {
        @NonNull ASTAssignableExpr leftOperand = n.getLeftOperand();
        if (leftOperand instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            @Nullable JVariableSymbol symbol = ((ASTAssignableExpr.ASTNamedReferenceExpr)leftOperand).getReferencedSym();
            return symbol != null && symbol.isFinal();
        }
        return false;
    }

    private boolean isBadTernary(ASTConditionalExpression ternary, ASTNullLiteral nullLiteral) {
        boolean isInitializer = false;
        ASTVariableDeclarator variableDeclarator = (ASTVariableDeclarator)ternary.ancestors(ASTVariableDeclarator.class).first();
        isInitializer = variableDeclarator != null && variableDeclarator.getInitializer() == ternary;
        boolean isThenOrElse = ternary.getThenBranch() == nullLiteral || ternary.getElseBranch() == nullLiteral;
        ASTConditionalExpression currentTernary = ternary;
        while (currentTernary.getParent() instanceof ASTConditionalExpression) {
            ASTConditionalExpression parentTernary = (ASTConditionalExpression)currentTernary.getParent();
            isThenOrElse &= parentTernary.getThenBranch() == currentTernary || parentTernary.getElseBranch() == currentTernary;
            currentTernary = parentTernary;
        }
        boolean isAssignment = currentTernary.getParent() instanceof ASTAssignmentExpression;
        return isThenOrElse && isAssignment && !isInitializer;
    }
}

