/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BasePolyMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseInvocMirror<T extends InvocationNode>
extends BasePolyMirror<T>
implements ExprMirror.InvocationMirror {
    private ExprMirror.InvocationMirror.MethodCtDecl ctDecl;
    private List<ExprMirror> args;

    BaseInvocMirror(JavaExprMirrors mirrors, T call, @Nullable ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, call, parent, subexprMaker);
    }

    @Override
    public boolean isEquivalentToUnderlyingAst() {
        ASTVariableId varId;
        ExprMirror.InvocationMirror.MethodCtDecl ctDecl = this.getCtDecl();
        AssertionUtil.validateState((ctDecl != null ? 1 : 0) != 0, (String)"overload resolution is not complete");
        if (ctDecl.isFailed()) {
            return false;
        }
        if (!((InvocationNode)this.myNode).getMethodType().getSymbol().equals(ctDecl.getMethodType().getSymbol())) {
            return false;
        }
        if (this.myNode instanceof ASTConstructorCall && ((ASTConstructorCall)this.myNode).isAnonymousClass() && !((ASTConstructorCall)this.myNode).getTypeNode().getTypeMirror().equals(this.getInferredType())) {
            return false;
        }
        if (((InvocationNode)this.myNode).getParent() instanceof ASTVariableDeclarator && (varId = ((ASTVariableDeclarator)((InvocationNode)this.myNode).getParent()).getVarId()).isTypeInferred() && !this.getInferredType().equals(varId.getTypeMirror())) {
            return false;
        }
        return CollectionUtil.all(this.getArgumentExpressions(), ExprMirror::isEquivalentToUnderlyingAst);
    }

    protected ExprMirror.InvocationMirror.MethodCtDecl getStandaloneCtdecl() {
        MethodCallSite site = this.factory.infer.newCallSite(this, null);
        return this.factory.infer.getCompileTimeDecl(site);
    }

    @Override
    public List<JTypeMirror> getExplicitTypeArguments() {
        return ASTList.orEmptyStream(((InvocationNode)this.myNode).getExplicitTypeArguments()).toStream().map(TypeNode::getTypeMirror).collect(Collectors.toList());
    }

    @Override
    public JavaNode getExplicitTargLoc(int i) {
        return (JavaNode)ASTList.orEmptyStream(((InvocationNode)this.myNode).getExplicitTypeArguments()).get(i);
    }

    @Override
    public List<ExprMirror> getArgumentExpressions() {
        if (this.args == null) {
            ASTArgumentList args = ((InvocationNode)this.myNode).getArguments();
            this.args = CollectionUtil.map(ASTList.orEmpty(args), this::createSubexpression);
        }
        return this.args;
    }

    @Override
    public int getArgumentCount() {
        return ASTList.sizeOrZero(((InvocationNode)this.myNode).getArguments());
    }

    @Override
    public void setCtDecl(ExprMirror.InvocationMirror.MethodCtDecl methodType) {
        this.ctDecl = methodType;
        if (this.mayMutateAst()) {
            InternalApiBridge.setOverload((InvocationNode)this.myNode, methodType);
        }
    }

    @Override
    public @Nullable ExprMirror.InvocationMirror.MethodCtDecl getCtDecl() {
        return this.ctDecl;
    }

    @Override
    public @Nullable JTypeMirror getReceiverType() {
        return null;
    }
}

