/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BaseInvocMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class MethodInvocMirror
extends BaseInvocMirror<ASTMethodCall>
implements ExprMirror.InvocationMirror {
    MethodInvocMirror(JavaExprMirrors mirrors, ASTMethodCall call, @Nullable ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, call, parent, subexprMaker);
    }

    @Override
    public @Nullable JTypeMirror getStandaloneType() {
        JMethodSig ctdecl = this.getStandaloneCtdecl().getMethodType();
        return MethodInvocMirror.isContextDependent(ctdecl) ? null : ctdecl.getReturnType();
    }

    private static boolean isContextDependent(JMethodSig m) {
        return (m = InternalMethodTypeItf.cast(m).adaptedMethod()).isGeneric() && TypeOps.mentionsAny(m.getReturnType(), m.getTypeParameters());
    }

    @Override
    public @NonNull ExprMirror.TypeSpecies getStandaloneSpecies() {
        return ExprMirror.TypeSpecies.getSpecies(this.getStandaloneCtdecl().getMethodType().getReturnType());
    }

    public List<JMethodSig> getAccessibleCandidates() {
        ASTConstructorCall ctor;
        ASTAnonymousClassDeclaration anon;
        ASTExpression lhs = ((ASTMethodCall)this.myNode).getQualifier();
        if (lhs == null) {
            return ((ASTMethodCall)this.myNode).getSymbolTable().methods().resolve(this.getName());
        }
        if (((ASTMethodCall)this.myNode).getEnclosingType() == null) {
            return Collections.emptyList();
        }
        JTypeMirror lhsType = lhs instanceof ASTConstructorCall ? ((anon = (ctor = (ASTConstructorCall)lhs).getAnonymousClassDeclaration()) != null ? anon.getTypeMirror(this.getTypingContext()) : ctor.getTypeMirror(this.getTypingContext())) : lhs.getTypeMirror(this.getTypingContext());
        lhsType = TypeConversion.capture(lhsType);
        boolean staticOnly = lhs instanceof ASTTypeExpression;
        return TypeOps.getMethodsOf(lhsType, this.getName(), staticOnly, ((ASTMethodCall)this.myNode).getEnclosingType().getSymbol());
    }

    @Override
    public JTypeMirror getErasedReceiverType() {
        return this.getReceiverType().getErasure();
    }

    @Override
    public @NonNull JTypeMirror getReceiverType() {
        ASTExpression qualifier = ((ASTMethodCall)this.myNode).getQualifier();
        if (qualifier != null) {
            return qualifier.getTypeMirror(this.getTypingContext());
        }
        return ((ASTMethodCall)this.myNode).getEnclosingType().getTypeMirror();
    }

    @Override
    public String getName() {
        return ((ASTMethodCall)this.myNode).getMethodName();
    }
}

