/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public interface ActiveMQServerControl {
    @Attribute(desc="server's version")
    public String getVersion();

    @Attribute(desc="number of clients connected to this server")
    public int getConnectionCount();

    @Attribute(desc="number of clients which have connected to this server since it was started")
    public long getTotalConnectionCount();

    @Attribute(desc="number of messages in all queues on the server")
    public long getTotalMessageCount();

    @Attribute(desc="number of messages sent to this server since it was started")
    public long getTotalMessagesAdded();

    @Attribute(desc="number of messages acknowledged from all the queues on this server since it was started")
    public long getTotalMessagesAcknowledged();

    @Attribute(desc="number of consumers consuming messages from all the queues on this server")
    public long getTotalConsumerCount();

    @Attribute(desc="whether this server is started")
    public boolean isStarted();

    @Attribute(desc="list of interceptors used by this server for incoming messages")
    public String[] getIncomingInterceptorClassNames();

    @Attribute(desc="list of interceptors used by this server for outgoing messages")
    public String[] getOutgoingInterceptorClassNames();

    @Attribute(desc="whether this server is clustered")
    public boolean isClustered();

    @Attribute(desc="maximum number of threads in the scheduled thread pool")
    public int getScheduledThreadPoolMaxSize();

    @Attribute(desc="maximum number of threads in the thread pool")
    public int getThreadPoolMaxSize();

    @Attribute(desc="interval time (in milliseconds) to invalidate security credentials")
    public long getSecurityInvalidationInterval();

    @Attribute(desc="whether security is enabled for this server")
    public boolean isSecurityEnabled();

    @Attribute(desc="file system directory used to store bindings")
    public String getBindingsDirectory();

    @Attribute(desc="file system directory used to store journal log")
    public String getJournalDirectory();

    @Attribute(desc="type of journal used by this server")
    public String getJournalType();

    @Attribute(desc="whether the journal is synchronized when receiving transactional data")
    public boolean isJournalSyncTransactional();

    @Attribute(desc="whether the journal is synchronized when receiving non-transactional datar")
    public boolean isJournalSyncNonTransactional();

    @Attribute(desc="size (in bytes) of each journal files")
    public int getJournalFileSize();

    @Attribute(desc="number of journal files to pre-create")
    public int getJournalMinFiles();

    @Attribute(desc="maximum number of write requests that can be in the AIO queue at any given time")
    public int getJournalMaxIO();

    @Attribute(desc="size of the internal buffer on the journal")
    public int getJournalBufferSize();

    @Attribute(desc="timeout (in nanoseconds) used to flush internal buffers on the journal")
    public int getJournalBufferTimeout();

    @Attribute(desc="if clients failover on a server shutdown")
    public void setFailoverOnServerShutdown(boolean var1) throws Exception;

    @Attribute(desc="if clients failover on a server shutdown")
    public boolean isFailoverOnServerShutdown();

    @Attribute(desc="minimal number of journal files before compacting")
    public int getJournalCompactMinFiles();

    @Attribute(desc="percentage of live data before compacting the journal")
    public int getJournalCompactPercentage();

    @Attribute(desc="whether this server is using persistence and store data")
    public boolean isPersistenceEnabled();

    @Attribute(desc="whether the bindings directory is created on this server startup")
    public boolean isCreateBindingsDir();

    @Attribute(desc="whether the journal directory is created on this server startup")
    public boolean isCreateJournalDir();

    @Attribute(desc="whether message counter is enabled for this server")
    public boolean isMessageCounterEnabled();

    @Attribute(desc="maximum number of days kept in memory for message counter")
    public int getMessageCounterMaxDayCount();

    @Attribute(desc="maximum number of days kept in memory for message counter")
    public void setMessageCounterMaxDayCount(int var1) throws Exception;

    @Attribute(desc="sample period (in milliseconds) to take message counter snapshot")
    public long getMessageCounterSamplePeriod();

    @Attribute(desc="sample period to take message counter snapshot")
    public void setMessageCounterSamplePeriod(long var1) throws Exception;

    @Attribute(desc="whether this server is a backup")
    public boolean isBackup();

    @Attribute(desc="whether this server shares its data store with a corresponding live or backup serve")
    public boolean isSharedStore();

    @Attribute(desc="file system directory used to store paging files")
    public String getPagingDirectory();

    @Attribute(desc="whether delivery count is persisted before messages are delivered to the consumers")
    public boolean isPersistDeliveryCountBeforeDelivery();

    @Attribute(desc="connection time to live")
    public long getConnectionTTLOverride();

    @Attribute(desc="management address of this server")
    public String getManagementAddress();

    @Attribute(desc="Node ID of this server")
    public String getNodeID();

    @Attribute(desc="management notification address of this server")
    public String getManagementNotificationAddress();

    @Attribute(desc="size of the cache for pre-creating message IDs")
    public int getIDCacheSize();

    @Attribute(desc="whether message ID cache is persisted")
    public boolean isPersistIDCache();

    @Attribute(desc="file system directory used to store large messages")
    public String getLargeMessagesDirectory();

    @Attribute(desc="whether wildcard routing is supported by this server")
    public boolean isWildcardRoutingEnabled();

    @Attribute(desc="timeout (in milliseconds) after which transactions is removed from the resource manager after it was created")
    public long getTransactionTimeout();

    @Attribute(desc="frequency (in milliseconds)  to scan transactions to detect which transactions have timed out")
    public long getTransactionTimeoutScanPeriod();

    @Attribute(desc="frequency (in milliseconds)  to scan messages to detect which messages have expired")
    public long getMessageExpiryScanPeriod();

    @Attribute(desc="priority of the thread used to scan message expiration")
    public long getMessageExpiryThreadPriority();

    @Attribute(desc="whether code coming from connection is executed asynchronously or not")
    public boolean isAsyncConnectionExecutionEnabled();

    @Attribute(desc="connectors configured for this server")
    public Object[] getConnectors() throws Exception;

    @Attribute(desc="connectors configured for this server using JSON serialization")
    public String getConnectorsAsJSON() throws Exception;

    @Attribute(desc="addresses created on this server")
    public String[] getAddressNames();

    @Attribute(desc="names of the queues created on this server")
    public String[] getQueueNames();

    @Attribute(desc="names of the queues created on this server with the given routing-type (i.e. ANYCAST or MULTICAST)")
    public String[] getQueueNames(String var1);

    @Attribute(desc="uptime of this server")
    public String getUptime();

    @Attribute(desc="uptime of this server in milliseconds")
    public long getUptimeMillis();

    @Attribute(desc="whether the initial replication synchronization process with the backup server is complete")
    public boolean isReplicaSync();

    @Attribute(desc="how often to check for disk space usage, in milliseconds")
    public int getDiskScanPeriod();

    @Attribute(desc="maximum limit for disk use, in percentage")
    public int getMaxDiskUsage();

    @Attribute(desc="global maximum limit for in-memory messages, in bytes")
    public long getGlobalMaxSize();

    @Operation(desc="Isolate the broker", impact=1)
    public boolean freezeReplication();

    @Operation(desc="create an address", impact=1)
    public String createAddress(@Parameter(name="name", desc="The name of the address") String var1, @Parameter(name="routingTypes", desc="Comma separated list of Routing Types (anycast/multicast)") String var2) throws Exception;

    @Operation(desc="update an address", impact=1)
    public String updateAddress(@Parameter(name="name", desc="The name of the address") String var1, @Parameter(name="routingTypes", desc="Comma separated list of Routing Types (anycast/multicast)") String var2) throws Exception;

    @Operation(desc="delete an address", impact=1)
    public void deleteAddress(@Parameter(name="name", desc="The name of the address") String var1) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue with the specified address", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2) throws Exception;

    @Operation(desc="Create a queue with the specified address", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var3) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue with the specified address, name and durability", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="durable", desc="Is the queue durable?") boolean var3) throws Exception;

    @Operation(desc="Create a queue with the specified address, name and durability", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="durable", desc="Is the queue durable?") boolean var3, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var4) throws Exception;

    @Operation(desc="Create a queue", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Create a queue", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var5) throws Exception;

    public String createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="name", desc="Name of the queue") String var3, @Parameter(name="filter", desc="Filter of the queue") String var4, @Parameter(name="durable", desc="Is the queue durable?") boolean var5, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") int var6, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") boolean var7, @Parameter(name="autoCreateAddress", desc="Create an address with default values should a matching address not be found") boolean var8) throws Exception;

    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var3, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var4) throws Exception;

    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3) throws Exception;

    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1, @Parameter(name="removeConsumers", desc="Remove consumers of this queue") boolean var2) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1, @Parameter(name="removeConsumers", desc="Remove consumers of this queue") boolean var2, @Parameter(name="autoDeleteAddress", desc="Automatically delete the address if this was the last queue") boolean var3) throws Exception;

    @Operation(desc="Enable message counters", impact=1)
    public void enableMessageCounters() throws Exception;

    @Operation(desc="Disable message counters", impact=1)
    public void disableMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters", impact=1)
    public void resetAllMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters history", impact=1)
    public void resetAllMessageCounterHistories() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first")
    public String[] listPreparedTransactions() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in JSON format")
    public String listPreparedTransactionDetailsAsJSON() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in HTML format")
    public String listPreparedTransactionDetailsAsHTML() throws Exception;

    @Operation(desc="List transactions which have been heuristically committed")
    public String[] listHeuristicCommittedTransactions() throws Exception;

    @Operation(desc="List transactions which have been heuristically rolled back")
    public String[] listHeuristicRolledBackTransactions() throws Exception;

    @Operation(desc="Commit a prepared transaction")
    public boolean commitPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="Rollback a prepared transaction")
    public boolean rollbackPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the consumer connections for the given messaging address", impact=0)
    public boolean closeConsumerConnectionsForAddress(@Parameter(desc="a messaging address", name="address") String var1) throws Exception;

    @Operation(desc="Closes all the connections for sessions with the given user name", impact=0)
    public boolean closeConnectionsForUser(@Parameter(desc="a user name", name="userName") String var1) throws Exception;

    @Operation(desc="Closes all the connection with the id", impact=0)
    public boolean closeConnectionWithID(@Parameter(desc="The connection ID", name="ID") String var1) throws Exception;

    @Operation(desc="Closes the session with the id", impact=0)
    public boolean closeSessionWithID(String var1, String var2) throws Exception;

    @Operation(desc="Closes the consumer with the id", impact=0)
    public boolean closeConsumerWithID(String var1, String var2) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    public String listProducersInfoAsJSON() throws Exception;

    @Operation(desc="List all connections as a JSON string")
    public String listConnectionsAsJSON() throws Exception;

    @Operation(desc="List all consumers associated with a connection as a JSON string")
    public String listConsumersAsJSON(String var1) throws Exception;

    @Operation(desc="List all consumers as a JSON string")
    public String listAllConsumersAsJSON() throws Exception;

    @Operation(desc="List the sessions for the given connectionID as a JSON string", impact=0)
    public String listSessionsAsJSON(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    public void sendQueueInfoToQueue(String var1, String var2) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8, @Parameter(desc="a comma-separated list of roles allowed to browse queues", name="browse") String var9) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8, @Parameter(desc="a comma-separated list of roles allowed to browse queues", name="browse") String var9, @Parameter(desc="a comma-separated list of roles allowed to create addresses", name="createAddressRoles") String var10, @Parameter(desc="a comma-separated list of roles allowed to delete addresses", name="deleteAddressRoles") String var11) throws Exception;

    @Operation(desc="Remove security settings for an address", impact=1)
    public void removeSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="get roles for a specific address match", impact=0)
    public Object[] getRoles(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="get roles (as a JSON string) for a specific address match", impact=0)
    public String getRolesAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean var31, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean var32, @Parameter(desc="allow topics to be created automatically", name="autoCreateAddresses") boolean var33, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteAddresses") boolean var34) throws Exception;

    public void removeAddressSettings(String var1) throws Exception;

    @Operation(desc="returns the address settings as a JSON string for an address match", impact=0)
    public String getAddressSettingsAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Attribute(desc="names of the diverts deployed on this server")
    public String[] getDivertNames();

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Address to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7) throws Exception;

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Address to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7, @Parameter(name="routingType", desc="How should the routing-type on the diverted messages be set?") String var8) throws Exception;

    @Operation(desc="Destroy a Divert", impact=1)
    public void destroyDivert(@Parameter(name="name", desc="Name of the divert") String var1) throws Exception;

    @Attribute(desc="names of the bridges deployed on this server")
    public String[] getBridgeNames();

    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the bridge") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="retryInterval", desc="Connection retry interval") long var6, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var8, @Parameter(name="initialConnectAttempts", desc="Number of initial connection attempts") int var10, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var11, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var12, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var13, @Parameter(name="producerWindowSize", desc="Producer window size") int var14, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var15, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var17, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var18, @Parameter(name="ha", desc="Is it using HA") boolean var19, @Parameter(name="user", desc="User name") String var20, @Parameter(name="password", desc="User password") String var21) throws Exception;

    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the bridge") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="retryInterval", desc="Connection retry interval") long var6, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var8, @Parameter(name="initialConnectAttempts", desc="Number of initial connection attempts") int var10, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var11, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var12, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var13, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var14, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var16, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var17, @Parameter(name="ha", desc="Is it using HA") boolean var18, @Parameter(name="user", desc="User name") String var19, @Parameter(name="password", desc="User password") String var20) throws Exception;

    @Operation(desc="Destroy a bridge", impact=1)
    public void destroyBridge(@Parameter(name="name", desc="Name of the bridge") String var1) throws Exception;

    @Operation(desc="Create a connector service", impact=1)
    public void createConnectorService(@Parameter(name="name", desc="Name of the connector service") String var1, @Parameter(name="factoryClass", desc="Class name of the connector service factory") String var2, @Parameter(name="parameters", desc="Parameter specific to the connector service") Map<String, Object> var3) throws Exception;

    @Operation(desc="Destroy a connector service", impact=1)
    public void destroyConnectorService(@Parameter(name="name", desc="Name of the connector service") String var1) throws Exception;

    @Attribute(desc="names of the connector services on this server")
    public String[] getConnectorServices();

    @Operation(desc="force the server to stop and notify clients to failover", impact=3)
    public void forceFailover() throws Exception;

    public void updateDuplicateIdCache(String var1, Object[] var2) throws Exception;

    @Operation(desc="force the server to stop and to scale down to another server", impact=3)
    public void scaleDown(@Parameter(name="name", desc="The connector to use to scale down, if not provided the first appropriate connector will be used") String var1) throws Exception;

    @Operation(desc="List the Network Topology", impact=0)
    public String listNetworkTopology() throws Exception;

    @Operation(desc="Get the selected address", impact=0)
    public String getAddressInfo(@Parameter(name="address", desc="The address") String var1) throws ActiveMQAddressDoesNotExistException;

    @Operation(desc="Get a list of bindings associated with an address", impact=0)
    public String listBindingsForAddress(@Parameter(name="address", desc="The address") String var1) throws Exception;

    @Operation(desc="List Addresses on the broker", impact=0)
    public String listAddresses(@Parameter(name="separator", desc="Separator used on the string listing") String var1) throws Exception;

    @Operation(desc="Search for Connections", impact=0)
    public String listConnections(@Parameter(name="Options") String var1, @Parameter(name="Page Number") int var2, @Parameter(name="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Sessions", impact=0)
    public String listSessions(@Parameter(name="Options") String var1, @Parameter(name="Page Number") int var2, @Parameter(name="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Consumers", impact=0)
    public String listConsumers(@Parameter(name="Options") String var1, @Parameter(name="Page Number") int var2, @Parameter(name="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Consumers", impact=0)
    public String listProducers(@Parameter(name="Options") String var1, @Parameter(name="Page Number") int var2, @Parameter(name="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Addresses", impact=0)
    public String listAddresses(@Parameter(name="Options") String var1, @Parameter(name="Page Number") int var2, @Parameter(name="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Queues", impact=0)
    public String listQueues(@Parameter(name="Options") String var1, @Parameter(name="Page Number") int var2, @Parameter(name="Page Size") int var3) throws Exception;
}

