/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.impl;

import java.io.StringReader;
import org.apache.activemq.artemis.selector.filter.BooleanExpression;
import org.apache.activemq.artemis.selector.filter.ComparisonExpression;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.hyphenated.HyphenatedParser;
import org.apache.activemq.artemis.selector.impl.LRUCache;
import org.apache.activemq.artemis.selector.strict.StrictParser;

public class SelectorParser {
    private static final LRUCache<String, Object> cache = new LRUCache(100);
    private static final String CONVERT_STRING_EXPRESSIONS_PREFIX = "convert_string_expressions:";
    private static final String HYPHENATED_PROPS_PREFIX = "hyphenated_props:";
    private static final String NO_CONVERT_STRING_EXPRESSIONS_PREFIX = "no_convert_string_expressions:";
    private static final String NO_HYPHENATED_PROPS_PREFIX = "no_hyphenated_props:";

    public static BooleanExpression parse(String sql) throws FilterException {
        Object result = cache.get(sql);
        if (result instanceof FilterException) {
            throw (FilterException)result;
        }
        if (result instanceof BooleanExpression) {
            return (BooleanExpression)result;
        }
        String actual = sql;
        boolean convertStringExpressions = false;
        boolean hyphenatedProps = false;
        while (true) {
            if (actual.startsWith(CONVERT_STRING_EXPRESSIONS_PREFIX)) {
                convertStringExpressions = true;
                actual = actual.substring(CONVERT_STRING_EXPRESSIONS_PREFIX.length());
                continue;
            }
            if (actual.startsWith(HYPHENATED_PROPS_PREFIX)) {
                hyphenatedProps = true;
                actual = actual.substring(HYPHENATED_PROPS_PREFIX.length());
                continue;
            }
            if (actual.startsWith(NO_CONVERT_STRING_EXPRESSIONS_PREFIX)) {
                convertStringExpressions = false;
                actual = actual.substring(NO_CONVERT_STRING_EXPRESSIONS_PREFIX.length());
                continue;
            }
            if (!actual.startsWith(NO_HYPHENATED_PROPS_PREFIX)) break;
            hyphenatedProps = false;
            actual = actual.substring(NO_HYPHENATED_PROPS_PREFIX.length());
        }
        if (convertStringExpressions) {
            ComparisonExpression.CONVERT_STRING_EXPRESSIONS.set(true);
        }
        try {
            Object parser;
            BooleanExpression e = null;
            if (hyphenatedProps) {
                parser = new HyphenatedParser(new StringReader(actual));
                e = ((HyphenatedParser)parser).JmsSelector();
            } else {
                parser = new StrictParser(new StringReader(actual));
                e = ((StrictParser)parser).JmsSelector();
            }
            cache.put(sql, e);
            parser = e;
            return parser;
        }
        catch (Throwable e) {
            FilterException fe = new FilterException(actual, e);
            cache.put(sql, fe);
            throw fe;
        }
        finally {
            if (convertStringExpressions) {
                ComparisonExpression.CONVERT_STRING_EXPRESSIONS.remove();
            }
        }
    }

    public static void clearCache() {
        cache.clear();
    }
}

