/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.AuthorizationDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.ChecksumEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class AuthenticatorEncoder
implements Encoder,
EncoderFactory {
    private static final int APPLICATION_CODE = 2;

    public byte[] encode(Encodable authenticator) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence replySequence = this.encodeInitialSequence((Authenticator)authenticator);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)2, (DEREncodable)replySequence));
        aos.close();
        return baos.toByteArray();
    }

    public Encoder getEncoder() {
        return new AuthenticatorEncoder();
    }

    private DERSequence encodeInitialSequence(Authenticator authenticator) {
        String clientRealm = authenticator.getClientPrincipal().getRealm();
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)authenticator.getVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERGeneralString.valueOf((String)clientRealm)));
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)PrincipalNameEncoder.encode(authenticator.getClientPrincipal())));
        if (authenticator.getChecksum() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)ChecksumEncoder.encode(authenticator.getChecksum())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)DERInteger.valueOf((int)authenticator.getClientMicroSecond())));
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)KerberosTimeEncoder.encode(authenticator.getClientTime())));
        if (authenticator.getSubSessionKey() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)EncryptionKeyEncoder.encodeSequence(authenticator.getSubSessionKey())));
        }
        if (authenticator.getSequenceNumber() > 0) {
            sequence.add((DEREncodable)new DERTaggedObject(7, (DEREncodable)DERInteger.valueOf((int)authenticator.getSequenceNumber())));
        }
        if (authenticator.getAuthorizationData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(8, (DEREncodable)AuthorizationDataEncoder.encode(authenticator.getAuthorizationData())));
        }
        return sequence;
    }
}

