/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class PreAuthenticationDataEncoder {
    public static byte[] encode(PaData[] preAuth) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)PreAuthenticationDataEncoder.encodeSequence(preAuth));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERSequence encodeSequence(PaData[] preAuth) {
        DERSequence sequence = new DERSequence();
        for (int ii = 0; ii < preAuth.length; ++ii) {
            sequence.add((DEREncodable)PreAuthenticationDataEncoder.encode(preAuth[ii]));
        }
        return sequence;
    }

    protected static DERSequence encode(PaData preAuth) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)preAuth.getPaDataType().getOrdinal())));
        if (preAuth.getPaDataValue() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DEROctetString(preAuth.getPaDataValue())));
        }
        return sequence;
    }
}

